/**
 * This package contains the interface and abstract base class for styles.
 * <p>
 * See the <a href="../../../../overview-summary.html">API overview</a> for general remarks on
 * how to use the install4j API.
 * </p>
 * <p>
 * The {@link com.install4j.api.styles.Style} interface contains all methods that have to be implemented by an actual style.
 * When you develop your own styles, it is recommended that you extend the abstract base classes in this package
 * rather than implement the interface itself.
 * </p>
 * <p>
 * Styles can nest other styles with help of the {@link com.install4j.api.styles.StyleManager}. Since there are a number of
 * delegations that have to be implemented correctly and the life-cycle of the screen style has to be taken into account, it is
 * advisable to use {@link com.install4j.api.styles.WrapperStyle} to nest a single style. To get more help with nesting styles,
 * see {@link com.install4j.api.styles.NestedStyleContainer}.
 * </p>
 */
package com.install4j.api.styles;