package com.install4j.api.screens;

import com.install4j.api.beans.AbstractBean;
import com.install4j.api.beans.Anchor;
import com.install4j.api.context.*;
import com.install4j.api.events.InstallerEvent;
import com.install4j.api.events.InstallerEventListener;
import com.install4j.api.formcomponents.WidgetStyleHandler;

/**
 * Abstract base class for screens that can be used in the installer or uninstaller.
 * All methods that have a reasonable default answer are overridden in the class.
 * This class saves the context that is set by the framework and provides getters for it.
 *
 * @author ej-technologies GmbH
 */
public abstract class AbstractInstallerOrUninstallerScreen extends AbstractBean implements InstallerScreen, UninstallerScreen, InstallerEventListener {

    private InstallerContext installerContext;
    private UninstallerContext uninstallerContext;
    private WidgetStyleHandler widgetStyleHandler;

    @Override
    public void setInstallerContext(InstallerContext context) {
        this.installerContext = context;
    }

    @Override
    public void setUninstallerContext(UninstallerContext context) {
        this.uninstallerContext = context;
    }


    @Override
    public void setWidgetStyleHandler(WidgetStyleHandler widgetStyleHandler) {
        this.widgetStyleHandler = widgetStyleHandler;
    }

    @Override
    public boolean isNextVisible() {
        return true;
    }

    @Override
    public boolean isPreviousVisible() {
        return true;
    }

    @Override
    public boolean isCancelVisible() {
        return true;
    }

    @Override
    public boolean isHiddenForNext() {
        return false;
    }

    @Override
    public boolean isHiddenForPrevious() {
        return false;
    }

    @Override
    public void activated() {
    }

    @Override
    public void deactivated() {
    }

    @Override
    public void installerEvent(InstallerEvent event) {
    }

    @Override
    public boolean next() {
        return true;
    }

    @Override
    public boolean previous() {
        return true;
    }

    @Override
    public boolean cancel() {
        return true;
    }

    @Override
    public void willActivate() {

    }

    /**
     * Returns a default value for the anchor of the screen component.
     * @return {@link Anchor#NORTHWEST}
     * @see com.install4j.api.beans.VisualContainerBean#getAnchor()
     */
    @Override
    public Anchor getAnchor() {
        return Anchor.NORTHWEST;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean handleUnattended() {
        return true;
    }

    @Override
    public boolean handleConsole(Console console) throws UserCanceledException {
        console.printHeader(getTitle());
        return true;
    }

    @Override
    public ProgressInterface getProgressInterface(ProgressInterface defaultProgressInterface) {
        return defaultProgressInterface;
    }

    @Override
    public boolean isCreateLazily() {
        return false;
    }

    /**
     * Returns the {@code WidgetStyleHandler} that the framework has associated with
     * this custom screen in {@link #setWidgetStyleHandler(WidgetStyleHandler)}.
     *
     * @return the widget style handler
     */
    public WidgetStyleHandler getWidgetStyleHandler() {
        return widgetStyleHandler;
    }

    /**
     * Returns the {@code InstallerContext} that the framework has associated with
     * this custom screen in {@link #setInstallerContext(InstallerContext)}.
     *
     * @return the installer context or  {@code null} if this screen is running in an uninstaller.
     */
    public InstallerContext getInstallerContext() {
        return installerContext;
    }

    /**
     * Returns the {@code UninstallerContext} that the framework has associated with
     * this custom screen in {@link #setUninstallerContext(UninstallerContext)}.
     *
     * @return the uninstaller context or {@code null} if this screen is running in an installer.
     */
    public UninstallerContext getUninstallerContext() {
        return uninstallerContext;
    }

    /**
     * Returns the {@code Context} that the framework has associated with
     * this custom screen in either {@link #setInstallerContext(InstallerContext)} or {@link #setUninstallerContext(UninstallerContext)}.
     *
     * @return the context.
     */
    public Context getContext() {
        return installerContext != null ? installerContext : uninstallerContext;
    }


}
