package com.install4j.api.context;

/**
 * This interface provides information about launchers.
 * Launchers are configured in the "Launchers" section of the install4j GUI.
 * <p>Objects of this type are returned by {@link Context#getLaunchers()} and {@link Context#getLauncherById(String)}.
 *
 * @author ej-technologies GmbH
 */
public interface LauncherSetup {

    /**
     * Get the relative file name for the launcher.
     * @return the relative file name.
     */
    String getRelativeFileName();

    /**
     * Get the ID of the launcher. The ID of a launcher
     * can be displayed in the install4j GUI by invoking Launcher-&gt;Show Launcher IDs from the main
     * menu when the Launchers section is active.
     * @return the ID.
     */
    String getId();

    /**
     * Get the type of the launcher.
     * @return the type
     */
    LauncherType getType();

    /**
     * Returns whether the launcher is excluded from menu integration. This concerns start menu entries on Windows
     * and the creation of links on Unix that are performed by the "Create default start menu entries" action.
     * @return {@code true} or {@code false}.
     */
    boolean isExcludeFromMenu();

    /**
     * Returns whether the launcher is the uninstaller.
     * @return {@code true} or {@code false}.
     */
    boolean isUninstaller();

    /**
     * Return the name of the launcher as configured in the install4j GUI.
     * @return the name
     */
    String getName();
}
