package com.install4j.api.context;

/**
 * Types of navigation buttons in the user interface. This is used by methods in
 * {@link WizardContext} and in the styles API.
 *
 * @see WizardContext
 * @see com.install4j.api.styles.ControlButton
 * @see com.install4j.api.styles.ControlButtonContainer
 */
public enum ControlButtonType {
    /**
     * The button to go to the previous screen.
     */
    PREVIOUS("Previous button"),
    /**
     * The button to go to the next screen.
     */
    NEXT("Next button"),
    /**
     * The button to cancel the installer application.
     */
    CANCEL("Cancel button");

    private final String verbose;

    ControlButtonType(String verbose) {
        this.verbose = verbose;
    }

    @Override
    public String toString() {
        return verbose;
    }
}
