package com.install4j.api.beans;

import java.io.Serializable;
import java.util.Objects;

/**
 * Property type for script properties to be used in beans.
 * You can define your own script properties where the user can configure a script in the install4j GUI that is
 * compiled by the install4j compiler and executed at runtime on your request.
 * A script is run via the context by invoking {@code Context.runScript} with the expected parameters for the script.
 * Parameters are configured via the corresponding BeanInfo class. The {@code ScriptPropertyDescriptor} class allows you to
 * create a property descriptor that contains information regarding return type and script parameters.
 *
 * @see com.install4j.api.context.Context#runScript(ScriptProperty, Bean, Object[])
 * @see com.install4j.api.beaninfo.ScriptPropertyDescriptor
 * @author ej-technologies GmbH
 */
public class ScriptProperty implements Serializable {

    private String value;

    /**
     * The constructor is called by the framework.
     */
    public ScriptProperty() {
    }

    /**
     * The constructor is called by the framework.
     */
    public ScriptProperty(String value) {
        this.value = value;
    }

    /**
     *  Required by the framework. Do not call directly.
     */
    public String getValue() {
        return value;
    }

    /**
     *  Required by the framework. Do not call directly.
     */
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        ScriptProperty other = (ScriptProperty)o;

        if (!Objects.equals(value, other.value)) {
            return false;
        }

        return true;
    }

    @Override
    public int hashCode() {
        return (value != null ? value.hashCode() : 0);
    }
}
