package com.install4j.api.actions;

import com.install4j.api.beans.AbstractBean;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;

/**
 * Abstract base class for install actions.
 * The {@code rollback} method does nothing by default. Override it in your action to perform an actual rollback.
 *
 * @author ej-technologies GmbH
 */
public abstract class AbstractInstallAction extends AbstractBean implements InstallAction {

    @Override
    public void rollback(InstallerContext context) {
    }

    @Override
    public void init(Context context) {
    }

    @Override
    public boolean isRollbackSupported() {
        return true;
    }
}
