/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.fileinst;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.context.FileOptions;
import com.install4j.api.context.UninstallMode;
import com.install4j.api.unix.UnixFileSystem;
import com.install4j.api.windows.RegistryRoot;
import com.install4j.api.windows.WinRegistry;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.fileinst.ExtendedFileOptions;
import com.install4j.runtime.installer.platform.macos.MacFileSystem;
import com.install4j.runtime.installer.platform.win32.FileVersion;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

class InstallHelper {
    private static final String KEY_SHARED_DLLS = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\SharedDLLs";
    private static final boolean DISABLE_WINDOWS_VERSION_COMPARISON = Boolean.getBoolean("install4j.disableWinVersionComparison");

    InstallHelper() {
    }

    private static Object addSharedCount(Object sharedCount, int delta) {
        int value = 1;
        try {
            if (sharedCount instanceof Integer) {
                value = (Integer)sharedCount + delta;
                sharedCount = value;
            } else if (sharedCount instanceof String) {
                value = Integer.parseInt((String)sharedCount) + delta;
                sharedCount = String.valueOf(value);
            } else if (sharedCount instanceof byte[]) {
                byte[] byteArray = (byte[])sharedCount;
                if (byteArray.length < 1 || byteArray.length > 4) {
                    throw new NumberFormatException();
                }
                int[] intArray = new int[4];
                for (int i = 0; i < byteArray.length; ++i) {
                    intArray[i] = byteArray[i];
                }
                value = (intArray[3] << 24) + (intArray[2] << 16) + (intArray[1] << 8) + (intArray[0] << 0);
                byteArray[0] = (byte)((value += delta) >>> 0 & 0xFF);
                byteArray[1] = (byte)(value >>> 8 & 0xFF);
                byteArray[2] = (byte)(value >>> 16 & 0xFF);
                byteArray[3] = (byte)(value >>> 24 & 0xFF);
            }
        }
        catch (NumberFormatException e) {
            sharedCount = value;
        }
        if (value <= 0) {
            return null;
        }
        return sharedCount;
    }

    static void registerShared(File file) {
        if (!InstallerUtil.isWindows()) {
            return;
        }
        Object sharedCount = WinRegistry.getValue(RegistryRoot.HKEY_LOCAL_MACHINE, KEY_SHARED_DLLS, file.getAbsolutePath());
        if (sharedCount == null) {
            sharedCount = 0;
        }
        sharedCount = InstallHelper.addSharedCount(sharedCount, 1);
        WinRegistry.setValue(RegistryRoot.HKEY_LOCAL_MACHINE, KEY_SHARED_DLLS, file.getAbsolutePath(), sharedCount);
    }

    static boolean unregisterShared(File file) {
        if (!InstallerUtil.isWindows()) {
            return true;
        }
        Object sharedCount = WinRegistry.getValue(RegistryRoot.HKEY_LOCAL_MACHINE, KEY_SHARED_DLLS, file.getAbsolutePath());
        if (sharedCount == null) {
            return true;
        }
        if ((sharedCount = InstallHelper.addSharedCount(sharedCount, -1)) == null) {
            WinRegistry.deleteValue(RegistryRoot.HKEY_LOCAL_MACHINE, KEY_SHARED_DLLS, file.getAbsolutePath());
            return true;
        }
        WinRegistry.setValue(RegistryRoot.HKEY_LOCAL_MACHINE, KEY_SHARED_DLLS, file.getAbsolutePath(), sharedCount);
        return false;
    }

    static UninstallMode getParentUninstallMode(UninstallMode uninstallMode) {
        if (uninstallMode == UninstallMode.ALWAYS) {
            return UninstallMode.IF_CREATED;
        }
        if (uninstallMode == UninstallMode.ALWAYS_BUT_NOT_FOR_UPDATE) {
            return UninstallMode.IF_CREATED_BUT_NOT_FOR_UPDATE;
        }
        return uninstallMode;
    }

    static void addDirs(File dir, Set<File> parentDirs) {
        if (dir != null) {
            try {
                dir = dir.getCanonicalFile();
            }
            catch (IOException e) {
                Logger.getInstance().log(e);
            }
            parentDirs.add(dir);
            InstallHelper.addDirs(dir.getParentFile(), parentDirs);
        }
    }

    static boolean isFirstFileNewer(@Nullable File firstFile, long firstTime, File secondFile) {
        if (firstFile != null && InstallerUtil.isWindows() && !DISABLE_WINDOWS_VERSION_COMPARISON) {
            int versionResult = FileVersion.compare(firstFile, secondFile);
            if (versionResult == 1) {
                Logger.getInstance().info(null, "Windows version info marks file as newer.");
                return true;
            }
            if (versionResult == 3) {
                Logger.getInstance().info(null, "File times: " + InstallHelper.getLastModified(firstFile) + ", " + InstallHelper.getLastModified(secondFile));
                return InstallHelper.getLastModified(firstFile) > InstallHelper.getLastModified(secondFile);
            }
            Logger.getInstance().info(null, "Windows version info marks file as older.");
            return false;
        }
        Logger.getInstance().info(null, "File times: " + firstTime + ", " + InstallHelper.getLastModified(secondFile));
        if (Files.isSymbolicLink(secondFile.toPath())) {
            return true;
        }
        return firstTime > InstallHelper.getLastModified(secondFile);
    }

    private static void deleteFile(File destFile) throws IOException {
        for (int i = 0; i < 20 && destFile.exists(); ++i) {
            if (destFile.delete()) continue;
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (destFile.exists() && !destFile.delete()) {
            throw new IOException("could not delete " + destFile);
        }
    }

    static void copyTemp(File tempFile, File destFile, FileOptions options) throws IOException {
        InstallHelper.deleteFile(destFile);
        FileUtil.rename(tempFile, destFile);
        destFile.setLastModified(options.getFileTime());
        if (!InstallerUtil.isWindows()) {
            UnixFileSystem.setMode(options.getMode(), destFile);
        }
        if (InstallerUtil.isMacOS() && options instanceof ExtendedFileOptions) {
            for (Map.Entry<String, String> entry : ((ExtendedFileOptions)options).getExtendedAttributes().entrySet()) {
                MacFileSystem.setExtendedAttribute(destFile, entry.getKey(), entry.getValue(), true);
            }
        }
    }

    public static long getLastModified(File file) {
        return file.lastModified();
    }

    public static void createSymlink(String target, File destFile, FileOptions options) throws IOException {
        InstallHelper.deleteFile(destFile);
        if (UnixFileSystem.createLink(target, destFile)) {
            if (InstallerUtil.isMacOS() && options instanceof ExtendedFileOptions) {
                for (Map.Entry<String, String> entry : ((ExtendedFileOptions)options).getExtendedAttributes().entrySet()) {
                    MacFileSystem.setExtendedAttribute(destFile, entry.getKey(), entry.getValue(), true);
                }
            }
        } else {
            throw new IOException("could not create symlink " + destFile);
        }
    }
}

