/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.filechooser;

import com.install4j.api.Util;
import com.install4j.runtime.alert.Alert;
import com.install4j.runtime.filechooser.AbstractFileSystemChooser;
import com.install4j.runtime.filechooser.MacosDirectoryChooser;
import com.install4j.runtime.filechooser.SwingDirectoryChooser;
import com.install4j.runtime.filechooser.WindowsDirectoryChooser;
import com.install4j.runtime.util.I4jLibraryHelper;
import java.io.File;
import java.util.Collection;
import java.util.Collections;

public abstract class DirectoryChooser
extends AbstractFileSystemChooser<DirectoryChooser> {
    protected boolean allowFilesOnMac;

    public static DirectoryChooser create() {
        if (Alert.isNoNativeDialogs()) {
            return new SwingDirectoryChooser();
        }
        if (!FORCE_FLATLAF_FILE_SELECTORS && Util.isMacOS()) {
            return new MacosDirectoryChooser();
        }
        if (!FORCE_FLATLAF_FILE_SELECTORS && Util.isAtLeastWindowsVista() && I4jLibraryHelper.isI4jLibraryAvailable()) {
            return new WindowsDirectoryChooser();
        }
        try {
            return (DirectoryChooser)Class.forName("com.install4j.runtime.flatlaf.FlatLafDirectoryChooser").newInstance();
        }
        catch (Throwable throwable) {
            return new SwingDirectoryChooser();
        }
    }

    protected abstract File getSelectedDirectoryInternal();

    public DirectoryChooser allowFilesOnMac(boolean allowFilesOnMac) {
        this.allowFilesOnMac = allowFilesOnMac;
        return this;
    }

    @Override
    protected Collection<File> getAllFiles() {
        return Collections.singleton(this.getSelectedDirectory());
    }

    @Override
    public File getSelectedFile() {
        return this.getSelectedDirectory();
    }

    public File getSelectedDirectory() {
        this.checkSelected();
        return this.getSelectedDirectoryInternal();
    }
}

