/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.Util;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.formcomponents.CustomizationSelection;
import com.install4j.runtime.beans.formcomponents.StreamlinedInstallationStrategy;
import com.install4j.runtime.beans.formcomponents.SystemFormComponent;
import com.install4j.runtime.beans.formcomponents.UpdateAlertSelection;
import com.install4j.runtime.beans.formcomponents.WidgetStyleHandlerImpl;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.util.CustomPanel;
import com.install4j.runtime.util.DisplayTextArea;
import com.install4j.runtime.util.ToolTipHelpLabel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JRadioButton;

public class StreamlinedInstallationChooserComponent
extends SystemFormComponent {
    public static final String FORM_VARIABLE_WELCOME_MESSAGE = "welcomeMessage";
    public static final String FORM_VARIABLE_FOOTER_MESSAGE = "footerMessage";
    private StreamlinedInstallationStrategy streamlinedInstallationStrategy = StreamlinedInstallationStrategy.ALWAYS;
    private UpdateAlertSelection updateAlertSelection = UpdateAlertSelection.EXISTING;
    private CustomizationSelection customizationSelection = CustomizationSelection.STREAMLINED;
    private ScriptProperty selectionScript;
    private JRadioButton rdoInstallStreamlined;
    private JRadioButton rdoInstallCustomized;
    private ButtonGroup bgrInstall;
    private ToolTipHelpLabel helpLabel;

    public StreamlinedInstallationStrategy getStreamlinedInstallationStrategy() {
        return this.replaceWithTextOverride("streamlinedInstallationStrategy", this.streamlinedInstallationStrategy, StreamlinedInstallationStrategy.class);
    }

    public void setStreamlinedInstallationStrategy(StreamlinedInstallationStrategy streamlinedInstallationStrategy) {
        this.streamlinedInstallationStrategy = streamlinedInstallationStrategy;
    }

    public UpdateAlertSelection getUpdateAlertSelection() {
        return this.replaceWithTextOverride("updateAlertSelection", this.updateAlertSelection, UpdateAlertSelection.class);
    }

    public void setUpdateAlertSelection(UpdateAlertSelection updateAlertSelection) {
        this.updateAlertSelection = updateAlertSelection;
    }

    public CustomizationSelection getCustomizationSelection() {
        return this.replaceWithTextOverride("customizationSelection", this.customizationSelection, CustomizationSelection.class);
    }

    public void setCustomizationSelection(CustomizationSelection customizationSelection) {
        this.customizationSelection = customizationSelection;
    }

    public ScriptProperty getSelectionScript() {
        return this.replaceWithTextOverride("selectionScript", this.selectionScript, ScriptProperty.class);
    }

    public void setSelectionScript(ScriptProperty selectionScript) {
        this.selectionScript = selectionScript;
    }

    @Override
    public boolean isFillCenterHorizontal() {
        return true;
    }

    @Override
    public JComponent createCenterComponent() {
        boolean updateOnly;
        CustomPanel panel = new CustomPanel(new GridBagLayout());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = 0;
        gc.anchor = 23;
        gc.fill = 2;
        gc.weightx = 1.0;
        boolean bl = updateOnly = this.getStreamlinedInstallationStrategy() == StreamlinedInstallationStrategy.UPDATE_ONLY;
        if (updateOnly) {
            DisplayTextArea dtxa = this.createStyledDisplayTextArea();
            Context context = this.getContext();
            dtxa.setText("\n" + context.getMessage(".PreviousInstallationLabel"));
            panel.add((Component)dtxa, gc);
            gc.fill = 0;
            ++gc.gridy;
        }
        ItemListener listener = e -> {
            if (e.getStateChange() == 1) {
                this.executeSelectionScript();
            }
        };
        WidgetStyleHandlerImpl widgetStyleHandler = this.getWidgetStyleHandler();
        this.rdoInstallStreamlined = widgetStyleHandler.applyWidgetStyle(new JRadioButton());
        this.rdoInstallStreamlined.setOpaque(false);
        this.rdoInstallCustomized = widgetStyleHandler.applyWidgetStyle(new JRadioButton());
        this.rdoInstallCustomized.setOpaque(false);
        this.rdoInstallCustomized.addItemListener(listener);
        if (updateOnly && this.getUpdateAlertSelection() == UpdateAlertSelection.DIFFERENT || !updateOnly && this.getCustomizationSelection() == CustomizationSelection.CUSTOMIZED) {
            this.rdoInstallCustomized.setSelected(true);
        } else {
            this.rdoInstallStreamlined.setSelected(true);
        }
        this.rdoInstallStreamlined.addItemListener(listener);
        this.bgrInstall = new ButtonGroup();
        this.bgrInstall.add(this.rdoInstallStreamlined);
        this.bgrInstall.add(this.rdoInstallCustomized);
        this.helpLabel = new ToolTipHelpLabel("");
        gc.fill = 0;
        gc.insets.top = 5;
        Box box = new Box(2);
        box.add(this.rdoInstallStreamlined);
        box.add(Box.createHorizontalStrut(5));
        box.add(this.helpLabel);
        panel.add((Component)box, gc);
        gc.insets.top = 0;
        ++gc.gridy;
        panel.add((Component)this.rdoInstallCustomized, gc);
        ++gc.gridy;
        return panel;
    }

    public void updateHelpLabel() {
        this.helpLabel.setToolTipText(this.getContext().getInstallationDirectory().getPath());
    }

    public boolean isUpdate() {
        return this.rdoInstallStreamlined.isSelected();
    }

    @Override
    public void formWillActivate() {
        super.formWillActivate();
        Context context = this.getContext();
        this.updateRadioButtons();
        StreamlinedInstallationStrategy streamlinedInstallationStrategy = this.getStreamlinedInstallationStrategy();
        if (this.getFormEnvironment().isDesignTime() || streamlinedInstallationStrategy == StreamlinedInstallationStrategy.ALWAYS) {
            this.setVisible(true);
        } else if (streamlinedInstallationStrategy == StreamlinedInstallationStrategy.UPDATE_ONLY && this.isUpdateInstallation()) {
            this.updateHelpLabel();
            this.setVisible(true);
        } else {
            this.setVisible(false);
        }
        boolean updateInstallation = context instanceof InstallerContext && ((InstallerContext)context).isUpdateInstallation();
        this.getFormEnvironment().setFormVariable(FORM_VARIABLE_WELCOME_MESSAGE, Messages.format(StreamlinedInstallationChooserComponent.replaceVariables(context.getMessage(updateInstallation ? (this.isVisible() ? ".ConsoleWelcomeUpdateLabel" : ".WelcomeUpdateLabel") : (this.isVisible() ? ".ConsoleWelcomeLabel" : ".WelcomeLabel3"))), context.getApplicationName()));
        this.getFormEnvironment().setFormVariable(FORM_VARIABLE_FOOTER_MESSAGE, Messages.format(StreamlinedInstallationChooserComponent.replaceVariables(context.getMessage(updateInstallation ? ".ClickUpdate" : ".ClickInstall")), context.getApplicationName()));
    }

    private void updateRadioButtons() {
        Context context = this.getContext();
        boolean updateOnly = this.getStreamlinedInstallationStrategy() == StreamlinedInstallationStrategy.UPDATE_ONLY;
        this.helpLabel.setVisible(updateOnly);
        this.rdoInstallStreamlined.setText(context.getMessage(updateOnly ? ".RadioUpdateInstallation" : ".RadioStreamlinedInstallation"));
        this.rdoInstallCustomized.setText(context.getMessage(updateOnly ? ".RadioNewInstallation" : ".RadioCustomizedInstallation"));
    }

    @Override
    public void formActivated() {
        super.formActivated();
        if (this.isVisible()) {
            this.executeSelectionScript();
        }
    }

    private void executeSelectionScript() {
        try {
            this.getContext().runScript(this.getSelectionScript(), this, this.getFormEnvironment(), this.rdoInstallStreamlined.isSelected());
        }
        catch (Exception e) {
            Util.printAnnotatedStackTrace(e);
            Logger.getInstance().log(e);
        }
    }

    private boolean isUpdateInstallation() {
        Context context = this.getContext();
        return context instanceof InstallerContext && ((InstallerContext)context).isUpdateInstallation();
    }

    @Override
    public boolean checkCompleted() {
        if (this.getContext().isGui() && this.isVisible()) {
            this.getContext().setVariable("sys.streamlinedInstallation", this.isUpdate());
        }
        return super.checkCompleted();
    }

    @Override
    public boolean handleConsole(Console console) throws UserCanceledException {
        StreamlinedInstallationStrategy streamlinedInstallationStrategy = this.getStreamlinedInstallationStrategy();
        Context context = this.getContext();
        if (streamlinedInstallationStrategy == StreamlinedInstallationStrategy.ALWAYS) {
            int result = console.askOption(context.getMessage(".StreamlinedInstallationConsole", this.getContext().getInstallationDirectory().getPath()), new String[]{context.getMessage(".RadioStreamlinedInstallation"), context.getMessage(".RadioCustomizedInstallation")}, null, this.getCustomizationSelection() == CustomizationSelection.CUSTOMIZED ? 1 : 0, false, true);
            context.setVariable("sys.streamlinedInstallation", result == 0);
        } else if (streamlinedInstallationStrategy == StreamlinedInstallationStrategy.UPDATE_ONLY && this.isUpdateInstallation()) {
            int result = console.askOption(context.getMessage(".PreviousInstallationConsole", this.getContext().getInstallationDirectory().getPath()), new String[]{context.getMessage(".RadioUpdateInstallation"), context.getMessage(".RadioNewInstallation")}, null, this.getUpdateAlertSelection() == UpdateAlertSelection.DIFFERENT ? 1 : 0, false, true);
            context.setVariable("sys.streamlinedInstallation", result == 0);
        }
        return true;
    }
}

