/*
 * Decompiled with CFR 0.152.
 */
package org.pkcs11.jacknji11;

public interface AttributeLengthStrategy {
    public int getAttributeLength(long var1);

    public static class IndefiniteLengthStrategy
    implements AttributeLengthStrategy {
        @Override
        public int getAttributeLength(long cka) {
            return 0;
        }
    }

    public static class MaxLengthStrategy
    implements AttributeLengthStrategy {
        public static final int DEFAULT_LARGE_ATTRIBUTE_LENGTH = 2048;
        public static final int DEFAULT_REGULAR_ATTRIBUTE_LENGTH = 72;
        public static final long[] DEFAULT_LARGE_ATTRIBUTES = new long[]{288L, 292L, 293L, 294L, 295L, 296L, 291L, 17L, 385L};
        private final long[] largeAttributes;
        private final int largeAttributeLength;
        private final int regularAttributeLength;

        public MaxLengthStrategy() {
            this(72, DEFAULT_LARGE_ATTRIBUTES, 2048);
        }

        public MaxLengthStrategy(int regularAttributeLength, long[] largeAttributes, int largeAttributeLength) {
            this.largeAttributes = largeAttributes;
            this.regularAttributeLength = regularAttributeLength;
            this.largeAttributeLength = largeAttributeLength;
        }

        @Override
        public int getAttributeLength(long cka) {
            if (MaxLengthStrategy.contains(this.largeAttributes, cka)) {
                return this.largeAttributeLength;
            }
            return this.regularAttributeLength;
        }

        private static boolean contains(long[] array, long value) {
            for (long l : array) {
                if (l != value) continue;
                return true;
            }
            return false;
        }
    }
}

