/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.wizard;

import com.ejt.internal.gui.LookAndFeelChangeUtil;
import com.ejt.internal.gui.ScreenSizeUtil;
import com.install4j.api.UiUtil;
import com.install4j.runtime.installer.frontend.GUIHelper;
import java.awt.Color;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.UIManager;

public abstract class CustomFrame
extends JFrame {
    public CustomFrame() {
        UiUtil.getLookAndFeelEnhancer().prepareWindow(this);
        LookAndFeelChangeUtil.registerWindow(this);
        LookAndFeelChangeUtil.onLookAndFeelChangeAndNow(this, CustomFrame::updateTitleBar);
        LookAndFeelChangeUtil.onLookAndFeelChangeAndNow(this, CustomFrame::updateBackgroundColor);
    }

    private void updateTitleBar() {
        CustomFrame.updateTitleBar(this.getRootPane(), this.getTitlePaneBackgroundColor());
    }

    public static void updateTitleBar(JRootPane rootPane, Color titleBarBackgroundColor) {
        if (!Boolean.getBoolean("install4j.useTitlePaneBackground")) {
            rootPane.putClientProperty("JRootPane.titleBarBackground", titleBarBackgroundColor);
        }
    }

    private void updateBackgroundColor() {
        this.setBackground(UIManager.getColor("control"));
    }

    protected Color getTitlePaneBackgroundColor() {
        return UIManager.getColor("Panel.background");
    }

    protected abstract int getFrameHeight();

    protected abstract int getFrameWidth();

    protected Rectangle getNewFrameBounds() {
        int frameWidth = this.getFrameWidth();
        int frameHeight = this.getFrameHeight();
        frameWidth = frameWidth == -1 ? this.getWidth() : (frameWidth *= (int)UiUtil.getLookAndFeelEnhancer().getCustomScaleFactor());
        frameHeight = frameHeight == -1 ? this.getHeight() : (frameHeight *= (int)UiUtil.getLookAndFeelEnhancer().getCustomScaleFactor());
        return this.getNewFrameBounds(frameWidth, frameHeight);
    }

    protected Rectangle getNewFrameBounds(int frameWidth, int frameHeight) {
        GraphicsDevice screenDevice = ScreenSizeUtil.getScreenDevice();
        Rectangle screenBounds = screenDevice.getDefaultConfiguration().getBounds();
        int newX = screenBounds.x + (screenBounds.width - frameWidth) / 2;
        int newY = screenBounds.y + (screenBounds.height - frameHeight) / 2;
        return new Rectangle(newX, newY, frameWidth, frameHeight);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            GUIHelper.applyComponentOrientation(this);
        }
        super.setVisible(visible);
    }
}

