/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.config.update;

import com.install4j.api.update.UpdateChecker;
import com.install4j.api.update.UpdateDescriptorEntry;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.ContextInt;
import com.install4j.runtime.installer.config.AbstractConfig;
import com.install4j.runtime.installer.helper.XmlHelper;
import com.install4j.runtime.launcher.integration.AutomaticUpdate;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Locale;
import java.util.Objects;
import org.w3c.dom.Element;

public class UpdateDescriptorEntryImpl
extends AbstractConfig
implements UpdateDescriptorEntry {
    public static final String ELEMENT_ENTRY = "entry";
    public static final String ELEMENT_COMMENT = "comment";
    public static final String ATTRIBUTE_TARGET_MEDIA_FILE_ID = "targetMediaFileId";
    public static final String ATTRIBUTE_UPDATABLE_VERSION_MIN = "updatableVersionMin";
    public static final String ATTRIBUTE_UPDATABLE_VERSION_MAX = "updatableVersionMax";
    public static final String ATTRIBUTE_FILE_NAME = "fileName";
    public static final String ATTRIBUTE_NEW_VERSION = "newVersion";
    public static final String ATTRIBUTE_NEW_MEDIA_FILE_ID = "newMediaFileId";
    public static final String ATTRIBUTE_FILE_SIZE = "fileSize";
    public static final String ATTRIBUTE_MD5_SUM = "md5Sum";
    public static final String ATTRIBUTE_SHA256_SUM = "sha256Sum";
    public static final String ATTRIBUTE_BUNDLED_JRE = "bundledJre";
    public static final String ATTRIBUTE_JRE_MIN_VERSION = "jreMinVersion";
    public static final String ATTRIBUTE_JRE_MAX_VERSION = "jreMaxVersion";
    public static final String ATTRIBUTE_ARCHIVE = "archive";
    public static final String ATTRIBUTE_SINGLE_BUNDLE = "singleBundle";
    public static final String ATTRIBUTE_LANGUAGE = "language";
    private String targetMediaFileId = "";
    private String updatableVersionMin = "";
    private String updatableVersionMax = "";
    private String fileName = "";
    private String newVersion = "";
    private String newMediaFileId = "";
    protected long fileSize = -1L;
    protected String md5Sum;
    protected String sha256Sum;
    private String bundledJre = "";
    private String jreMinVersion = "";
    private String jreMaxVersion = "";
    private String comment = "";
    private boolean archive = false;
    private boolean singleBundle = false;
    private Element element;
    private URL url;

    public UpdateDescriptorEntryImpl() {
    }

    public UpdateDescriptorEntryImpl(String mediaFileId, String fileName, String newVersion, long fileSize, String bundledJre, boolean archive, boolean singleBundle, String updatableVersionMin, String updatableVersionMax) {
        this(mediaFileId, fileName, newVersion, fileSize, null, null, bundledJre, "", "", archive, singleBundle, updatableVersionMin, updatableVersionMax);
    }

    public UpdateDescriptorEntryImpl(String mediaFileId, String fileName, String newVersion, long fileSize, String md5Sum, String sha256Sum, String bundledJre, String jreMinVersion, String jreMaxVersion, boolean archive, boolean singleBundle, String updatableVersionMin, String updatableVersionMax) {
        this.targetMediaFileId = mediaFileId;
        this.fileName = fileName;
        this.newVersion = newVersion;
        this.fileSize = fileSize;
        this.md5Sum = md5Sum;
        this.sha256Sum = sha256Sum;
        this.bundledJre = bundledJre;
        this.jreMinVersion = jreMinVersion;
        this.jreMaxVersion = jreMaxVersion;
        this.newMediaFileId = mediaFileId;
        this.archive = archive;
        this.singleBundle = singleBundle;
        this.updatableVersionMin = updatableVersionMin;
        this.updatableVersionMax = updatableVersionMax;
    }

    @Override
    protected void read(Element element) {
        this.element = element;
        this.targetMediaFileId = UpdateDescriptorEntryImpl.readAttribute(element, ATTRIBUTE_TARGET_MEDIA_FILE_ID, this.targetMediaFileId);
        this.updatableVersionMin = UpdateDescriptorEntryImpl.readAttribute(element, ATTRIBUTE_UPDATABLE_VERSION_MIN, this.updatableVersionMin);
        this.updatableVersionMax = UpdateDescriptorEntryImpl.readAttribute(element, ATTRIBUTE_UPDATABLE_VERSION_MAX, this.updatableVersionMax);
        this.fileName = UpdateDescriptorEntryImpl.readAttribute(element, ATTRIBUTE_FILE_NAME, this.fileName);
        this.newVersion = UpdateDescriptorEntryImpl.readAttribute(element, ATTRIBUTE_NEW_VERSION, this.newVersion);
        this.newMediaFileId = UpdateDescriptorEntryImpl.readAttribute(element, ATTRIBUTE_NEW_MEDIA_FILE_ID, this.newMediaFileId);
        this.fileSize = UpdateDescriptorEntryImpl.readAttribute(element, ATTRIBUTE_FILE_SIZE, this.fileSize);
        this.md5Sum = UpdateDescriptorEntryImpl.readAttribute(element, ATTRIBUTE_MD5_SUM, this.md5Sum);
        this.sha256Sum = UpdateDescriptorEntryImpl.readAttribute(element, ATTRIBUTE_SHA256_SUM, this.sha256Sum);
        this.bundledJre = UpdateDescriptorEntryImpl.readAttribute(element, ATTRIBUTE_BUNDLED_JRE, this.bundledJre);
        this.jreMinVersion = UpdateDescriptorEntryImpl.readAttribute(element, ATTRIBUTE_JRE_MIN_VERSION, this.jreMinVersion);
        this.jreMaxVersion = UpdateDescriptorEntryImpl.readAttribute(element, ATTRIBUTE_JRE_MAX_VERSION, this.jreMaxVersion);
        this.archive = UpdateDescriptorEntryImpl.readAttribute(element, ATTRIBUTE_ARCHIVE, this.archive);
        this.singleBundle = UpdateDescriptorEntryImpl.readAttribute(element, ATTRIBUTE_SINGLE_BUNDLE, this.archive);
        ContextInt context = ContextImpl.getSingleContextInt();
        String systemLanguage = context != null ? context.getLanguageId() : Locale.getDefault().getLanguage();
        Element principalElement = null;
        Element systemElement = null;
        for (Element commentElement : XmlHelper.childElements(element)) {
            String language;
            if (!Objects.equals(commentElement.getNodeName(), ELEMENT_COMMENT)) continue;
            if (principalElement == null) {
                principalElement = commentElement;
            }
            if (!systemLanguage.startsWith(language = UpdateDescriptorEntryImpl.readAttribute(commentElement, ATTRIBUTE_LANGUAGE, ""))) continue;
            systemElement = commentElement;
        }
        if (systemElement == null) {
            systemElement = principalElement;
        }
        this.comment = XmlHelper.getTextValue(systemElement).trim();
    }

    public void setURL(URL url) {
        this.url = url;
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public boolean isArchive() {
        return this.archive;
    }

    @Override
    public boolean isSingleBundle() {
        return this.singleBundle;
    }

    @Override
    public String getAdditionalAttribute(String attributeName, String defaultValue) {
        return UpdateDescriptorEntryImpl.readAttribute(this.element, attributeName, defaultValue);
    }

    @Override
    public String getTargetMediaFileId() {
        return this.targetMediaFileId;
    }

    public void setTargetMediaFileId(String targetMediaFileId) {
        this.targetMediaFileId = targetMediaFileId;
    }

    @Override
    public String getUpdatableVersionMin() {
        return this.updatableVersionMin;
    }

    public void setUpdatableVersionMin(String updatableVersionMin) {
        this.updatableVersionMin = updatableVersionMin;
    }

    @Override
    public String getUpdatableVersionMax() {
        return this.updatableVersionMax;
    }

    public void setUpdatableVersionMax(String updatableVersionMax) {
        this.updatableVersionMax = updatableVersionMax;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public String getNewVersion() {
        return this.newVersion;
    }

    public void setNewVersion(String newVersion) {
        this.newVersion = newVersion;
    }

    @Override
    public String getNewMediaFileId() {
        return this.newMediaFileId;
    }

    public void setNewMediaFileId(String newMediaFileId) {
        this.newMediaFileId = newMediaFileId;
    }

    @Override
    public long getFileSize() {
        return this.fileSize;
    }

    @Override
    public String getMd5Sum() {
        return this.md5Sum;
    }

    @Override
    public String getSha256Sum() {
        return this.sha256Sum;
    }

    @Override
    public String getFileSizeVerbose() {
        if (this.fileSize / 1024L / 1024L > 0L) {
            return new DecimalFormat("#0.0").format(1.0 * (double)this.fileSize / 1024.0 / 1024.0) + " MB";
        }
        return this.fileSize / 1024L + " KB";
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    @Override
    public String getBundledJre() {
        return this.bundledJre;
    }

    public void setBundledJre(String bundledJre) {
        this.bundledJre = bundledJre;
    }

    @Override
    public String getJreMinVersion() {
        return this.jreMinVersion;
    }

    @Override
    public String getJreMaxVersion() {
        return this.jreMaxVersion;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String toString() {
        return "UpdateDescriptorEntry [target: " + this.targetMediaFileId + ", file: " + this.getFileName() + ", version: " + this.getNewVersion() + "]";
    }

    @Override
    public boolean checkVersionCompatible(String version) {
        String minVersion = this.updatableVersionMin.trim();
        if (!minVersion.isEmpty() && !UpdateChecker.isVersionLessThanOrEqual(minVersion, version)) {
            return false;
        }
        String maxVersion = this.updatableVersionMax.trim();
        if (!maxVersion.isEmpty() && !UpdateChecker.isVersionLessThanOrEqual(version, maxVersion)) {
            return false;
        }
        return UpdateChecker.isVersionGreaterThan(this.newVersion, version);
    }

    @Override
    public boolean isDownloaded() {
        if (this.newVersion != null) {
            return AutomaticUpdate.isScheduled(this.newVersion, false, false);
        }
        return false;
    }
}

