/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.Util;
import com.install4j.runtime.beans.formcomponents.FormattedTextfieldComponent;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.MaskFormatter;

public class MaskTextfieldComponent
extends FormattedTextfieldComponent {
    private String inputMask = "###-##-####";
    private String placeholderCharacter = "0";
    private boolean valueContainsLiteralCharacters = true;
    private String validCharacters = "";
    private String invalidCharacters = "";
    private boolean allowsInvalid = false;

    public String getInputMask() {
        return MaskTextfieldComponent.replaceVariables(this.inputMask);
    }

    public void setInputMask(String inputMask) {
        this.inputMask = inputMask;
    }

    public String getPlaceholderCharacter() {
        return MaskTextfieldComponent.replaceVariables(this.placeholderCharacter);
    }

    public boolean isValueContainsLiteralCharacters() {
        return this.replaceWithTextOverride("valueContainsLiteralCharacters", this.valueContainsLiteralCharacters);
    }

    public void setValueContainsLiteralCharacters(boolean valueContainsLiteralCharacters) {
        this.valueContainsLiteralCharacters = valueContainsLiteralCharacters;
    }

    public String getValidCharacters() {
        return MaskTextfieldComponent.replaceVariables(this.validCharacters);
    }

    public void setValidCharacters(String validCharacters) {
        this.validCharacters = validCharacters;
    }

    public String getInvalidCharacters() {
        return MaskTextfieldComponent.replaceVariables(this.invalidCharacters);
    }

    public void setInvalidCharacters(String invalidCharacters) {
        this.invalidCharacters = invalidCharacters;
    }

    public void setPlaceholderCharacter(String placeholderCharacter) {
        this.placeholderCharacter = placeholderCharacter.isEmpty() ? " " : placeholderCharacter.substring(0, 1);
    }

    public boolean isAllowsInvalid() {
        return this.replaceWithTextOverride("allowsInvalid", this.allowsInvalid);
    }

    public void setAllowsInvalid(boolean allowsInvalid) {
        this.allowsInvalid = allowsInvalid;
    }

    @Override
    protected DefaultFormatter createFormatter() {
        try {
            MaskFormatter maskFormatter = new MaskFormatter(this.getInputMask());
            maskFormatter.setPlaceholderCharacter(this.getPlaceholderCharacter().charAt(0));
            maskFormatter.setValueContainsLiteralCharacters(this.isValueContainsLiteralCharacters());
            if (!this.getValidCharacters().trim().isEmpty()) {
                maskFormatter.setValidCharacters(this.getValidCharacters());
            }
            if (!this.getInvalidCharacters().trim().isEmpty()) {
                maskFormatter.setInvalidCharacters(this.getInvalidCharacters());
            }
            maskFormatter.setAllowsInvalid(this.isAllowsInvalid());
            return maskFormatter;
        }
        catch (ParseException e) {
            Util.fatalError(e);
            return null;
        }
    }

    @Override
    protected String getFormatDescription() {
        JFormattedTextField textField = (JFormattedTextField)this.getTextComponent();
        return " [" + ((MaskFormatter)textField.getFormatter()).getMask() + "]";
    }
}

