/*
 * Decompiled with CFR 0.152.
 */
package com.ejt.internal.util;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CmdLineParser {
    private String[] remainingArgs = null;
    private Map<Object, Option> options = new HashMap<Object, Option>(10);
    private Map<String, List<Object>> values = new HashMap<String, List<Object>>(10);

    public final Option addOption(Option opt) {
        if (opt.shortForm() != null) {
            this.options.put("-" + opt.shortForm(), opt);
        }
        this.options.put("--" + opt.longForm(), opt);
        return opt;
    }

    public final Option addStringOption(char shortForm, String longForm) {
        return this.addOption(new Option.StringOption(shortForm, longForm));
    }

    public final Option addStringOption(String longForm) {
        return this.addOption(new Option.StringOption(longForm));
    }

    public final Option addIntegerOption(char shortForm, String longForm) {
        return this.addOption(new Option.IntegerOption(shortForm, longForm));
    }

    public final Option addIntegerOption(String longForm) {
        return this.addOption(new Option.IntegerOption(longForm));
    }

    public final Option addLongOption(char shortForm, String longForm) {
        return this.addOption(new Option.LongOption(shortForm, longForm));
    }

    public final Option addLongOption(String longForm) {
        return this.addOption(new Option.LongOption(longForm));
    }

    public final Option addDoubleOption(char shortForm, String longForm) {
        return this.addOption(new Option.DoubleOption(shortForm, longForm));
    }

    public final Option addDoubleOption(String longForm) {
        return this.addOption(new Option.DoubleOption(longForm));
    }

    public final Option addBooleanOption(char shortForm, String longForm) {
        return this.addOption(new Option.BooleanOption(shortForm, longForm));
    }

    public final Option addBooleanOption(String longForm) {
        return this.addOption(new Option.BooleanOption(longForm));
    }

    public final Object getOptionValue(Option o) {
        return this.getOptionValue(o, null);
    }

    @NotNull
    public final Object getNonNullOptionValue(Option o, @NotNull Object def) {
        Object optionValue = this.getOptionValue(o, def);
        if (optionValue != null) {
            return optionValue;
        }
        return def;
    }

    public final Object getOptionValue(Option o, Object def) {
        List<Object> v = this.values.get(o.longForm());
        if (v == null) {
            return def;
        }
        if (v.isEmpty()) {
            return null;
        }
        Object result = v.get(0);
        v.remove(0);
        return result;
    }

    public final List<Object> getOptionValues(Option option) {
        ArrayList<Object> result = new ArrayList<Object>();
        Object o;
        while ((o = this.getOptionValue(option, null)) != null) {
            result.add(o);
        }
        return result;
    }

    public final String[] getRemainingArgs() {
        return this.remainingArgs;
    }

    public final void parse(String[] argv) throws IllegalOptionValueException, UnknownOptionException {
        this.parse(argv, Locale.getDefault());
    }

    public final void parse(String[] argv, Locale locale) throws IllegalOptionValueException, UnknownOptionException {
        ArrayList<String> otherArgs = new ArrayList<String>();
        int position = 0;
        this.values = new HashMap<String, List<Object>>(10);
        while (position < argv.length) {
            String curArg = argv[position];
            if (curArg.startsWith("-")) {
                Object value;
                if (curArg.equals("--")) {
                    ++position;
                    break;
                }
                String valueArg = null;
                if (curArg.startsWith("--")) {
                    int equalsPos = curArg.indexOf("=");
                    if (equalsPos != -1) {
                        valueArg = curArg.substring(equalsPos + 1);
                        curArg = curArg.substring(0, equalsPos);
                    }
                } else if (curArg.length() > 2) {
                    for (int i = 1; i < curArg.length(); ++i) {
                        Option opt = this.options.get("-" + curArg.charAt(i));
                        if (opt == null) {
                            throw new UnknownSuboptionException(curArg, curArg.charAt(i));
                        }
                        if (opt.wantsValue()) {
                            throw new NotFlagException(curArg, curArg.charAt(i));
                        }
                        this.addValue(opt, opt.getValue(null, locale));
                    }
                    ++position;
                    continue;
                }
                Option opt = this.options.get(curArg);
                if (opt == null) {
                    throw new UnknownOptionException(curArg);
                }
                if (opt.wantsValue()) {
                    if (valueArg == null && ++position < argv.length) {
                        valueArg = argv[position];
                    }
                    value = opt.getValue(valueArg, locale);
                } else {
                    value = opt.getValue(null, locale);
                }
                this.addValue(opt, value);
            } else {
                otherArgs.add(curArg);
            }
            ++position;
        }
        while (position < argv.length) {
            otherArgs.add(argv[position]);
            ++position;
        }
        this.remainingArgs = otherArgs.toArray(new String[0]);
    }

    private void addValue(Option opt, Object value) {
        String lf = opt.longForm();
        this.values.computeIfAbsent(lf, k -> new ArrayList()).add(value);
    }

    public static abstract class Option {
        private String shortForm;
        private String longForm;
        private boolean wantsValue;

        protected Option(String longForm, boolean wantsValue) {
            this(null, longForm, wantsValue);
        }

        protected Option(char shortForm, String longForm, boolean wantsValue) {
            this(String.valueOf(shortForm), longForm, wantsValue);
        }

        private Option(String shortForm, String longForm, boolean wantsValue) {
            if (longForm == null) {
                throw new IllegalArgumentException("Null longForm not allowed");
            }
            this.shortForm = shortForm;
            this.longForm = longForm;
            this.wantsValue = wantsValue;
        }

        public String shortForm() {
            return this.shortForm;
        }

        public String longForm() {
            return this.longForm;
        }

        public boolean wantsValue() {
            return this.wantsValue;
        }

        public final Object getValue(String arg, Locale locale) throws IllegalOptionValueException {
            if (this.wantsValue) {
                if (arg == null) {
                    throw new IllegalOptionValueException(this, "");
                }
                return this.parseValue(arg, locale);
            }
            return Boolean.TRUE;
        }

        protected Object parseValue(String arg, Locale locale) throws IllegalOptionValueException {
            return null;
        }

        public static class StringOption
        extends Option {
            public StringOption(char shortForm, String longForm) {
                super(shortForm, longForm, true);
            }

            public StringOption(String longForm) {
                super(longForm, true);
            }

            @Override
            protected Object parseValue(String arg, Locale locale) {
                return arg;
            }
        }

        public static class DoubleOption
        extends Option {
            public DoubleOption(char shortForm, String longForm) {
                super(shortForm, longForm, true);
            }

            public DoubleOption(String longForm) {
                super(longForm, true);
            }

            @Override
            protected Object parseValue(String arg, Locale locale) throws IllegalOptionValueException {
                try {
                    NumberFormat format = NumberFormat.getNumberInstance(locale);
                    Number num = format.parse(arg);
                    return num.doubleValue();
                }
                catch (ParseException e) {
                    throw new IllegalOptionValueException(this, arg);
                }
            }
        }

        public static class LongOption
        extends Option {
            public LongOption(char shortForm, String longForm) {
                super(shortForm, longForm, true);
            }

            public LongOption(String longForm) {
                super(longForm, true);
            }

            @Override
            protected Object parseValue(String arg, Locale locale) throws IllegalOptionValueException {
                try {
                    return Long.parseLong(arg);
                }
                catch (NumberFormatException e) {
                    throw new IllegalOptionValueException(this, arg);
                }
            }
        }

        public static class IntegerOption
        extends Option {
            public IntegerOption(char shortForm, String longForm) {
                super(shortForm, longForm, true);
            }

            public IntegerOption(String longForm) {
                super(longForm, true);
            }

            @Override
            protected Object parseValue(String arg, Locale locale) throws IllegalOptionValueException {
                try {
                    return Integer.parseInt(arg);
                }
                catch (NumberFormatException e) {
                    throw new IllegalOptionValueException(this, arg);
                }
            }
        }

        public static class BooleanOption
        extends Option {
            public BooleanOption(char shortForm, String longForm) {
                super(shortForm, longForm, false);
            }

            public BooleanOption(String longForm) {
                super(longForm, false);
            }
        }
    }

    public static class IllegalOptionValueException
    extends OptionException {
        private Option option;
        private String value;

        public IllegalOptionValueException(Option opt, String value) {
            super("Illegal value '" + value + "' for option " + (opt.shortForm() != null ? "-" + opt.shortForm() + "/" : "") + "--" + opt.longForm());
            this.option = opt;
            this.value = value;
        }

        public Option getOption() {
            return this.option;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class NotFlagException
    extends UnknownOptionException {
        private char notFlag;

        private NotFlagException(String option, char flag) {
            super(option, "Illegal option: '" + option + "', '" + flag + "' requires a value");
            this.notFlag = flag;
        }

        public char getOptionChar() {
            return this.notFlag;
        }
    }

    public static class UnknownSuboptionException
    extends UnknownOptionException {
        private char suboption;

        private UnknownSuboptionException(String option, char suboption) {
            super(option, "Illegal option: '" + suboption + "' in '" + option + "'");
            this.suboption = suboption;
        }

        public char getSuboption() {
            return this.suboption;
        }
    }

    public static class UnknownOptionException
    extends OptionException {
        private String optionName;

        private UnknownOptionException(String optionName) {
            this(optionName, "Unknown option '" + optionName + "'");
        }

        private UnknownOptionException(String optionName, String msg) {
            super(msg);
            this.optionName = optionName;
        }

        public String getOptionName() {
            return this.optionName;
        }
    }

    public static abstract class OptionException
    extends Exception {
        private OptionException(String msg) {
            super(msg);
        }
    }
}

