/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.xml;

import com.install4j.api.beaninfo.BeanValidationException;
import com.install4j.api.beaninfo.Install4JPropertyDescriptor;
import com.install4j.api.beans.Bean;
import com.install4j.runtime.beans.BeanInfo;
import com.install4j.runtime.beans.actions.xml.AbstractModifyMultipleXmlFilesAction;
import com.install4j.runtime.beans.actions.xml.AbstractModifyMultipleXmlFilesActionBeanInfo;
import com.install4j.runtime.beans.actions.xml.FragmentInsertMode;
import com.install4j.runtime.beans.actions.xml.FragmentSource;
import com.install4j.runtime.beans.actions.xml.InsertXmlFragmentAction;

@BeanInfo
public class InsertXmlFragmentActionBeanInfo
extends AbstractModifyMultipleXmlFilesActionBeanInfo {
    private static final String PROPERTY_FRAGMENT_SOURCE = "fragmentSource";
    private static final String PROPERTY_FRAGMENT_TEXT = "fragmentText";
    private static final String PROPERTY_FRAGMENT_FILE = "fragmentFile";
    private static final String PROPERTY_FRAGMENT_INSERT_MODE = "fragmentInsertMode";

    public InsertXmlFragmentActionBeanInfo() {
        super("Insert XML fragment into XML files", "Insert an XML fragment into the position defined by an XPath expression. The fragment can replace an existing element node, or it can be inserted as a child or a sibling.", (Class<? extends AbstractModifyMultipleXmlFilesAction>)InsertXmlFragmentAction.class);
        this.addXPathProperty("The XPath expression to the DOM nodes for which the insertion or replacement should be performed. The result of the XPath expression should consist of one or more element nodes and not of attribute or text nodes.<p> Example for selecting nodes by position: <tt>/levelOne[2]/levelTwo[4]</tt>.<br/>Example for selecting nodes by attribute: <tt>/myRootNode/myChildNode[@id='123']</tt>.</p><p>If no match can be found, the action will fail.</p>");
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_FRAGMENT_SOURCE, (Class)this.getBeanClass(), (String)"XML fragment source", (String)"The XML fragment that is inserted can either be entered directly in a text editor or be read from a file."));
        this.addPropertyDescriptor(this.reparent(FragmentSource.DIRECT, Install4JPropertyDescriptor.create((String)PROPERTY_FRAGMENT_TEXT, (Class)this.getBeanClass(), (String)"XML fragment text", (String)"The XML fragment that should be inserted. The fragment must not include an XML declaration and can contain multiple top-level elements.<p>Example: <tt>&lt;insert&gt;1&lt;/insert&gt;&lt;insert&gt;2&lt;/insert&gt;</tt></p>", (String)"multiline")));
        this.addPropertyDescriptor(this.reparent(FragmentSource.FILE, Install4JPropertyDescriptor.create((String)PROPERTY_FRAGMENT_FILE, (Class)this.getBeanClass(), (String)"XML fragment file", (String)"The source file with the XML fragment that should be inserted. The file has to contain a well-formed XML file. The root element is discarded and the XML fragment is formed from its immediate children.", (String)"externalOrInternal")));
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_FRAGMENT_INSERT_MODE, (Class)this.getBeanClass(), (String)"Insert mode", (String)("For each result of the XPath expression, the selected action is performed. You can replace the matched element, insert the fragment as a sibling or as a child.<p>To insert as the n-th child, enter a positional XPath expression like <tt>/root/nested[3]</tt>, and choose \"" + String.valueOf(FragmentInsertMode.BEFORE) + "\".</p>")));
    }

    private Install4JPropertyDescriptor reparent(FragmentSource fragmentSource, Install4JPropertyDescriptor install4JPropertyDescriptor) {
        install4JPropertyDescriptor.setParentProperty(PROPERTY_FRAGMENT_SOURCE);
        install4JPropertyDescriptor.setVisibilityDiscriminator((bean, object) -> object == fragmentSource);
        return install4JPropertyDescriptor;
    }

    @Override
    public void validateBean(Bean bean) throws BeanValidationException {
        super.validateBean(bean);
        FragmentSource fragmentSource = ((InsertXmlFragmentAction)bean).getFragmentSource();
        switch (fragmentSource) {
            case DIRECT: {
                this.checkNotEmpty(PROPERTY_FRAGMENT_TEXT, bean);
                break;
            }
            case FILE: {
                this.checkNotEmpty(PROPERTY_FRAGMENT_FILE, bean);
            }
        }
    }
}

