/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.update;

import com.install4j.api.beaninfo.ActionElevationType;
import com.install4j.api.beaninfo.BeanInitializer;
import com.install4j.api.beaninfo.BeanValidationException;
import com.install4j.api.beaninfo.BeanValidator;
import com.install4j.api.beaninfo.Install4JPropertyDescriptor;
import com.install4j.api.beans.Bean;
import com.install4j.api.update.UpdateDescriptor;
import com.install4j.runtime.beans.BeanInfo;
import com.install4j.runtime.beans.actions.net.DownloadAction;
import com.install4j.runtime.beans.actions.net.DownloadActionBeanInfo;
import com.install4j.runtime.beans.actions.update.CheckForUpdateAction;

@BeanInfo
public class CheckForUpdateActionBeanInfo
extends DownloadActionBeanInfo
implements BeanInitializer,
BeanValidator {
    private static final String PROPERTY_VARIABLE = "variable";

    public CheckForUpdateActionBeanInfo() {
        super("Check for update", "Load the update descriptor from a URL and save it to a variable. If successful, the variable will contain an instance of <tt>com.install4j.api.UpdateDescriptor</tt>", "Update", true, false, (Integer)null, (Class<? extends DownloadAction>)CheckForUpdateAction.class);
        this.setDefaultActionElevationType(ActionElevationType.NONE, true);
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_VARIABLE, (Class)this.getBeanClass(), (String)"Variable", (String)"The installer variable to which an instance of class <tt>com.install4j.api.UpdateDescriptor</tt> will be saved if the action is successful.", (String)"variableName").setVariableValueClass(UpdateDescriptor.class));
    }

    @Override
    protected String getUrlShortDescription() {
        return "The URL from which the update descriptor for this project can be downloaded. The update descriptor file is automatically created when compiling the project and can be found in the media output directory.  The URL must start with <tt>http://</tt> or <tt>https://</tt>. If you add a query string, it must already be URL encoded.<p>For testing purposes, you can also use a file URL like <tt>file:/c:/test/updates.xml</tt>.</p>";
    }

    @Override
    protected String getUrlDisplayName() {
        return "Update descriptor URL";
    }

    @Override
    public void validateBean(Bean bean) throws BeanValidationException {
        super.validateBean(bean);
        this.checkNotEmpty(PROPERTY_VARIABLE, bean);
    }

    public void initializeBean(Bean bean) {
        ((CheckForUpdateAction)bean).setUrl("${installer:updatesUrl?:${compiler:sys.updatesUrl}}");
    }
}

