package com.install4j.api.windows;

import com.install4j.runtime.installer.platform.win32.FolderInfo;

/**
 * Enumeration class for the different special system folders in Microsoft Windows.

 * @author ej-technologies GmbH
 */
public enum SpecialFolder {
    /**
     * The directory used to store file objects on the desktop.
     * A typical path is {@code C:\Users\<i>user name</i>\Desktop}.
     */
    DESKTOP(FolderInfo.FOLDER_DESKTOP),

    /**
     * The directory containing Start menu items.
     * A typical path is {@code C:\Users\<i>user name</i>\AppData\Roaming\Microsoft\Windows\Start Menu}.
     */
    STARTMENU(FolderInfo.FOLDER_STARTMENU),

    /**
     * The directory that contains the user's start menu entries.
     * The groups are themselves file system directories.
     * A typical path is {@code C:\Users\<i>user name</i>\AppData\Roaming\Microsoft\Windows\Start Menu\Programs}.
     */
    PROGRAMS(FolderInfo.FOLDER_PROGRAMS),

    /**
     * The directory that corresponds to the user's Startup start menu folder.
     * A typical path is {@code C:\Users\<i>user name</i>\AppData\Roaming\Microsoft\Windows\Start Menu\Programs\Startup}.
     */
    STARTUP(FolderInfo.FOLDER_STARTUP),

    /**
     * The directory that contains Send To menu items.
     * A typical path is {@code C:\Users\<i>user name</i>\AppData\Roaming\Microsoft\Windows\SendTo}.
     */
    SENDTO(FolderInfo.FOLDER_SENDTO),

    /**
     * Identifies a virtual folder containing fonts.
     * A typical path is {@code C:\Windows\Fonts}.
     */
    FONTS(FolderInfo.FOLDER_FONTS),

    /**
     * The directory that serves as a common repository for application-specific data.
     * A typical path is {@code C:\Users\<i>user name</i>\AppData\Roaming}.
     */
    APPDATA(FolderInfo.FOLDER_APPDATA),

    /**
     * The directory used to physically store a user's common repository of documents.
     * A typical path is {@code C:\Users\<i>user name</i>\Documents}.
     */
    DOCS(FolderInfo.FOLDER_DOCS),

    /**
     * The directory that serves as a common repository for document templates.
     * A typical path is {@code C:\Users\<i>user name</i>\AppData\Roaming\Microsoft\Windows\Templates}.
     */
    TEMPLATES(FolderInfo.FOLDER_TEMPLATES),

    /**
     * The directory that serves as a common repository for the user's favorite items.
     * A typical path is {@code C:\Users\<i>user name</i>\Favorites}.
     */
    FAVORITES(FolderInfo.FOLDER_FAVORITES),

    /**
     * The directory that serves as a data repository for local applications.
     * A typical path is {@code C:\Users\<i>user name</i>\AppData\Local}.
     */
    LOCAL_APPDATA(FolderInfo.FOLDER_LOCAL_APPDATA),

    /**
     * The directory that serves as a data repository for local applications with low access rights.
     * A typical path is {@code C:\Users\<i>user name</i>\AppData\LocalLow}.
     */
    LOCAL_APPDATA_LOW(FolderInfo.KNOWN_FOLDER_LOCAL_APP_DATA_LOW),

    /**
     * The directory that program files should be installed to.
     * A typical path is {@code C:\Users\<i>user name</i>\AppData\Local\Programs}.
     */
    PROGRAM_FILES(FolderInfo.KNOWN_FOLDER_USER_PROGRAM_FILES),

    /**
     * The directory that shared program files should be installed to.
     * A typical path is {@code C:\Users\<i>user name</i>\AppData\Local\Programs\Common}.
     */
    PROGRAM_FILES_COMMON(FolderInfo.KNOWN_FOLDER_USER_PROGRAM_FILES_COMMON);

    private final int intValue;

    SpecialFolder(int intValue) {
        this.intValue = intValue;
    }

    int getIntValue() {
        return intValue;
    }


}
