package com.install4j.api.styles;

import java.util.Collection;

/**
 * Implemented by styles that contain nested styles.
 * <p>
 * Some notes for working with nested styles:
 * </p>
 * <ul>
 * <li>
 * Use {@link StyleManager#cloneStyleById(String)} to get a screen style instance from the ID of a nested style. This ensures
 * that you can use multiple copies of the same screen style on the same screen.
 * </li>
 * <li>
 * Nested screen style can be configurable by the user if you add a {@code String} property for the style ID and set its context in the
 * {@code BeanInfo} to {@link com.install4j.api.beaninfo.Install4JPropertyDescriptor#CONTEXT_STYLE_ID}.
 * </li>
 * <li>
 * Never call  {@link Style#createComponent()} on nested styles, but use {@link StyleManager#createStyleComponent(Style)} instead.
 * That method ensures that for styles that implement {@link com.install4j.api.screens.FormPanelContainer}, a new
 * form panel has been set on the style.
 * </li>
 * <li>
 * The methods {@link Style#setStyleContext(StyleContext)}, {@link Style#willActivate()}, {@link Style#activated()} and
 * {@link Style#deactivated()} have to be delegated to any nested styles. These methods should not be called directly,
 * but rather through the helper methods in {@link StyleManager} so that any associated configurable forms are handled as well.
 * </li>
 * </ul>
 * <p>
 * To use a single nested style, it is advisable to derive from {@link WrapperStyle}. That class already implements
 * {@link NestedStyleContainer} and performs all necessary delegations. The "customCode" sample project contains
 * the class {@code SunnySkyBackgroundStyle} and its associated {@code BeanInfo} that show you an example for wrapping
 * a user-selected screen style with a graphical decoration. For more complex use cases, the source code
 * of {@link WrapperStyle} can be used as a starting point.
 * </p>
 *
 * @author ej-technologies GmbH
 */
public interface NestedStyleContainer {
    /**
     * Return the IDs of all nested styles. This allows the install4j IDE to collect all overridable properties.
     *
     * @return the IDs
     */
    Collection<String> getNestedStyleIds();
}
