package com.install4j.api.formcomponents;

import javax.swing.*;

/**
 * Represents the created GUI components for a form component.
 * If the installer or uninstaller is running in GUI mode, the framework will call the
 * {@code createLeftComponent}, {@code createCenterComponent} and {@code createRightComponent}
 * of a form component after instantiating it. These three components of which the left and right components
 * may be {@code null} form the <b>component tuple</b> of the form component.
 * <p>
 * A component tuple can be obtained for every form component via the form environment.
 * </p>
 * @see FormEnvironment#getComponentTuple(FormComponent) 
 */
public interface ComponentTuple {
    /**
     * Return the left GUI component created by {@code FormComponent.createLeftComponent}.
     * @return the left GUI component
     * @see FormComponent#createLeftComponent()
     */
    JComponent getLeftComponent();
    /**
     * Return the center GUI component created by {@code FormComponent.createCenterComponent}.
     * @return the center GUI component
     * @see FormComponent#createCenterComponent()
     */
    JComponent getCenterComponent();
    /**
     * Return the right GUI component created by {@code FormComponent.createRightComponent}.
     * @return the right GUI component
     * @see FormComponent#createRightComponent()
     */
    JComponent getRightComponent();
}
