package com.install4j.api.actions;

import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;

/**
 * All install actions must implement this interface. You have to override all methods and provide a public constructor with no arguments.
 * It is recommended that you choose one of the derived abstract classes as a superclass.
 *
 * @author ej-technologies GmbH
 */
public interface InstallAction extends Action {

    /**
     * This method is called by the framework to perform the action during installation.
     * You can use the {@code ProgressInterface} available from {@code context.getProgressInterface()}
     * in order to display messages to the user or ask simple questions.
     * For long-running actions, make sure to check {@code context.isCancelling()} frequently to comply
     * with a cancel request from the user.
     * @param context the context of the installation.
     * @return should return {@code true} if successful. If it returns {@code false}, the error message and the
     * failure strategy for the action configured in the install4j GUI will be used by the installer.
     * @throws UserCanceledException thrown, for example, by file installation methods. You can let
     * these exceptions pass through, they will be handled by the framework.
     */
    boolean install(InstallerContext context) throws UserCanceledException;

    /**
     * This method is called by the framework to perform a rollback of the {@code install} method.
     * This method is only called if the {@code install} method has already been
     * called and the installation is canceled by the user or if the installation fails. If this action is executed
     * before a rollback barrier that has already been passed successfully, the rollback will not be performed for this action.
     * The "Installation screen" is the only default rollback barrier in install4j.
     * @param context the context of the installation.
     */
    void rollback(InstallerContext context);

    /**
     * This method is called by the framework to determine if the action supports a rollback.
     * @return {@code true} if a rollback is supported.
     */
    boolean isRollbackSupported();

}
