/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class AutoResizingTextArea
extends JTextArea {
    public static final int DEFAULT_MAX_ROWS = 20;
    public static final int DEFAULT_MIN_ROWS = 1;
    private int _maxRows;
    private int _minRows;
    private ResizingDocumentListener _listener;

    public AutoResizingTextArea() {
        this(1, 20);
    }

    public AutoResizingTextArea(int n2) {
        this(n2, 20);
    }

    public AutoResizingTextArea(int n2, int n3) {
        this.setMinRows(n2);
        this.setMaxRows(n3);
        this.setRows(n2);
    }

    public AutoResizingTextArea(String string) {
        this();
        this.setText(string);
    }

    public AutoResizingTextArea(int n2, int n3, int n4) {
        this(n2, n3);
        this.setMinRows(n2);
        this.setMaxRows(n3);
        this.setColumns(n4);
    }

    public AutoResizingTextArea(String string, int n2, int n3, int n4) {
        this(n2, n3, n4);
        this.setText(string);
    }

    public AutoResizingTextArea(Document document) {
        this();
        this.setDocument(document);
    }

    public AutoResizingTextArea(Document document, String string, int n2, int n3, int n4) {
        super(document, string, n2, n4);
        this.setMaxRows(n3);
        this.setMinRows(n2);
    }

    @Override
    public void setRows(int n2) {
        int n3 = super.getRows();
        int n4 = this.clipRowCount(n2);
        super.setRows(n4);
        this.numberOfRowsUpdated(n3, n4);
    }

    protected void numberOfRowsUpdated(int n2, int n3) {
        Container container;
        JScrollPane jScrollPane = this.getParentScrollPane();
        if (jScrollPane != null && (container = jScrollPane.getParent()) != null && container instanceof JComponent) {
            JComponent jComponent = (JComponent)container;
            jComponent.revalidate();
        }
    }

    public int getMaxRows() {
        return this._maxRows;
    }

    public void setMaxRows(int n2) {
        this._maxRows = n2;
        this.setRows(this.clipRowCount(this.getRows()));
    }

    public int getMinRows() {
        return this._minRows;
    }

    public void setMinRows(int n2) {
        this._minRows = n2;
        this.setRows(this.clipRowCount(this.getRows()));
    }

    @Override
    public void setDocument(Document document) {
        Document document2 = this.getDocument();
        if (document2 != null && this._listener != null) {
            document2.removeDocumentListener(this._listener);
        }
        super.setDocument(document);
        if (document != null) {
            if (this._listener == null) {
                this._listener = new ResizingDocumentListener();
            }
            document.addDocumentListener(this._listener);
        }
        this.updateSize();
    }

    private int clipRowCount(int n2) {
        int n3 = Math.min(this._maxRows, n2);
        n3 = Math.max(this._minRows, n3);
        return n3;
    }

    private int getHeight(int n2) {
        Insets insets = this.getInsets();
        return n2 * this.getRowHeight() + insets.top + insets.bottom;
    }

    private void updateSize() {
        JScrollPane jScrollPane = this.getParentScrollPane();
        if (jScrollPane != null && jScrollPane.getParent() instanceof JComponent) {
            JComponent jComponent = (JComponent)jScrollPane.getParent();
            jComponent.revalidate();
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension dimension = this.getPreferredSize();
        if (this.getMinRows() != 0 && this.getMaxRows() != 0) {
            dimension.height = Math.max(this.getHeight(this.getMinRows()), Math.min(this.getHeight(this.getMaxRows()), dimension.height));
        }
        return dimension;
    }

    private JScrollPane getParentScrollPane() {
        Container container = this.getParent();
        if (container != null && container instanceof JViewport) {
            return (JScrollPane)container.getParent();
        }
        return null;
    }

    private class ResizingDocumentListener
    implements DocumentListener {
        private ResizingDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            AutoResizingTextArea.this.updateSize();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            AutoResizingTextArea.this.updateSize();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            AutoResizingTextArea.this.updateSize();
        }
    }
}

