/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.install4j.runtime.installer.helper.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class VariableEncoding {
    public static final String BOOLEAN_SUFFIX = "$Boolean";
    public static final String DATE_SUFFIX = "$Date";
    public static final String INTEGER_SUFFIX = "$Integer";
    public static final String LONG_SUFFIX = "$Long";
    public static final String INT_ARRAY_SUFFIX = "$IntArray";
    public static final String STRING_ARRAY_SUFFIX = "$StringArray";
    private static final Pattern ENUM_PATTERN = Pattern.compile("[^$]+(\\$[^$]+)");

    public static Map<String, Object> decodeVariables(Map<String, String> encodedVars, boolean ignoreErrors) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, String> entry : encodedVars.entrySet()) {
            String variableName = entry.getKey();
            String variableString = entry.getValue();
            String realName = VariableEncoding.getRealVariableName(variableName);
            try {
                result.put(realName, VariableEncoding.decodeVariable(variableName, variableString));
            }
            catch (Exception e) {
                if (ignoreErrors) continue;
                String errorMessage = "Could not decode variable " + variableName + ": " + e;
                Logger.getInstance().error(null, errorMessage);
                System.err.println(errorMessage);
            }
        }
        return result;
    }

    public static String getRealVariableName(String encodedVariableName) {
        int i = encodedVariableName.indexOf(36);
        if (i > -1) {
            return encodedVariableName.substring(0, i);
        }
        return encodedVariableName;
    }

    private static Object decodeVariable(@NotNull String variableName, @NotNull String variableString) {
        if (variableName.endsWith(BOOLEAN_SUFFIX)) {
            return Boolean.valueOf(variableString);
        }
        if (variableName.endsWith(DATE_SUFFIX)) {
            return new Date(Long.parseLong(variableString));
        }
        if (variableName.endsWith(INTEGER_SUFFIX)) {
            return Integer.valueOf(variableString);
        }
        if (variableName.endsWith(LONG_SUFFIX)) {
            return Long.valueOf(variableString);
        }
        if (variableName.endsWith(INT_ARRAY_SUFFIX)) {
            return VariableEncoding.decodeIntegerArray(variableString);
        }
        if (variableName.endsWith(STRING_ARRAY_SUFFIX)) {
            return VariableEncoding.decodeStringArray(variableString);
        }
        if (ENUM_PATTERN.matcher(variableName).matches()) {
            return VariableEncoding.decodeEnumValue(variableName, variableString);
        }
        return variableString;
    }

    public static Object decodeIntegerArray(String variableString) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(variableString, ",");
        while (tokenizer.hasMoreTokens()) {
            String sVal = tokenizer.nextToken();
            list.add(sVal.trim());
        }
        int[] ret = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            String s = (String)list.get(i);
            ret[i] = Integer.parseInt(s);
        }
        return ret;
    }

    public static Object decodeStringArray(String variableString) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder curVal = null;
        for (int i = 0; i < variableString.length(); ++i) {
            char c = variableString.charAt(i);
            if (i == 0 && c != '\"') {
                throw new IllegalArgumentException("Missing quote at the beginning of " + variableString);
            }
            if (c == '\"') {
                if (curVal == null) {
                    curVal = new StringBuilder();
                    continue;
                }
                list.add(curVal.toString());
                curVal = null;
                continue;
            }
            if (c == '\\') {
                ++i;
                if (curVal == null) continue;
                curVal.append(variableString.charAt(i));
                continue;
            }
            if (curVal != null) {
                curVal.append(c);
                continue;
            }
            if (c == ',' || Character.isWhitespace(c)) continue;
            throw new IllegalArgumentException("Illegal separator \"" + c + "\" in " + variableString);
        }
        if (curVal != null) {
            throw new IllegalArgumentException("Unmatched quotes in " + variableString);
        }
        String[] ret = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ret[i] = (String)list.get(i);
        }
        return ret;
    }

    private static Object decodeEnumValue(@NotNull String variableName, @NotNull String variableString) {
        String enumClass = variableName.substring(variableName.indexOf(36) + 1);
        try {
            Class<?> c = Class.forName(enumClass);
            if (!c.isEnum()) {
                Logger.getInstance().error(null, "Class " + enumClass + " is not an enum class");
                return variableString;
            }
            for (Object enumConstant : c.getEnumConstants()) {
                Enum enumValue = (Enum)enumConstant;
                if (!enumValue.name().equals(variableString)) continue;
                return enumValue;
            }
            Logger.getInstance().error(null, "Enum constant " + variableString + " not found in class " + enumClass);
        }
        catch (ClassNotFoundException e) {
            Logger.getInstance().error(null, "Class " + enumClass + " cannot be found");
        }
        return variableString;
    }

    public static boolean encodeVariable(Map<String, String> properties, String variableName, Object variableValue) {
        if (variableValue == null) {
            return false;
        }
        String encodedVariableName = VariableEncoding.getEncodedVariableName(variableName, variableValue);
        if (variableValue instanceof String) {
            properties.put(encodedVariableName, (String)variableValue);
        } else if (variableValue instanceof Boolean) {
            properties.put(encodedVariableName, variableValue.toString());
        } else if (variableValue instanceof Date) {
            properties.put(encodedVariableName, String.valueOf(((Date)variableValue).getTime()));
        } else if (variableValue instanceof Integer) {
            properties.put(encodedVariableName, variableValue.toString());
        } else if (variableValue instanceof Long) {
            properties.put(encodedVariableName, variableValue.toString());
        } else if (variableValue instanceof int[]) {
            int[] intArray = (int[])variableValue;
            StringBuilder value = new StringBuilder();
            for (int i = 0; i < intArray.length; ++i) {
                value.append(intArray[i]);
                if (i >= intArray.length - 1) continue;
                value.append(",");
            }
            properties.put(encodedVariableName, value.toString());
        } else if (variableValue instanceof String[]) {
            String[] stringArray = (String[])variableValue;
            StringBuilder value = new StringBuilder();
            for (int i = 0; i < stringArray.length; ++i) {
                value.append("\"").append(VariableEncoding.encodeArrayString(stringArray[i])).append("\"");
                if (i >= stringArray.length - 1) continue;
                value.append(",");
            }
            properties.put(encodedVariableName, value.toString());
        } else if (variableValue.getClass().isEnum()) {
            properties.put(encodedVariableName, ((Enum)variableValue).name());
        } else {
            return false;
        }
        return true;
    }

    public static String getEncodedVariableName(String variableName, Object variableValue) {
        if (variableValue instanceof Boolean) {
            return variableName + BOOLEAN_SUFFIX;
        }
        if (variableValue instanceof Date) {
            return variableName + DATE_SUFFIX;
        }
        if (variableValue instanceof Integer) {
            return variableName + INTEGER_SUFFIX;
        }
        if (variableValue instanceof Long) {
            return variableName + LONG_SUFFIX;
        }
        if (variableValue instanceof int[]) {
            return variableName + INT_ARRAY_SUFFIX;
        }
        if (variableValue instanceof String[]) {
            return variableName + STRING_ARRAY_SUFFIX;
        }
        if (variableValue != null && variableValue.getClass().isEnum()) {
            return variableName + "$" + variableValue.getClass().getName();
        }
        return variableName;
    }

    private static String encodeArrayString(String str) {
        if (str == null) {
            return "";
        }
        StringBuilder value = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\"') {
                value.append("\\\"");
                continue;
            }
            if (c == '\\') {
                value.append("\\\\");
                continue;
            }
            value.append(c);
        }
        return value.toString();
    }

    public static void main(String[] args) {
        HashMap<String, String> props = new HashMap<String, String>();
        VariableEncoding.encodeVariable(props, "stringVar", "test\\\"");
        VariableEncoding.encodeVariable(props, "booleanVar", Boolean.TRUE);
        VariableEncoding.encodeVariable(props, "integerVar", 123);
        VariableEncoding.encodeVariable(props, "dateVar", new Date());
        VariableEncoding.encodeVariable(props, "intArray", new int[0]);
        VariableEncoding.encodeVariable(props, "stringArray", new String[0]);
        VariableEncoding.encodeVariable(props, "stringArray2", new String[]{"One", "Two\" c\\3"});
        System.out.println(props);
        HashMap<String, String> encoded = new HashMap<String, String>(props);
        System.out.println("decode");
        Map<String, Object> result = VariableEncoding.decodeVariables(encoded, false);
        for (Map.Entry<String, Object> entry : result.entrySet()) {
            System.out.println(entry.getKey());
            List<String> value = entry.getValue();
            List<String> displayValue = value instanceof String[] ? Arrays.asList((String[])value) : value;
            System.out.println(entry.getValue().getClass().getName() + ": " + displayValue);
            System.out.println("---------");
        }
    }
}

