/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.control;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallAction;
import com.install4j.runtime.beans.actions.control.InstallationScope;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.CompilerVariableHelper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.apiimpl.ApplicationRegistryImpl;
import com.install4j.runtime.installer.helper.registry.InstallRegistry;
import com.install4j.runtime.installer.platform.win32.Misc;
import com.install4j.runtime.installer.platform.win32.PE32Handler;
import java.io.File;
import java.util.Objects;

public class SetInstallationDirectoryAction
extends SystemInstallAction {
    private InstallationScope installationScope = InstallationScope.DIRECTORY_WRITABLE;
    private boolean skipForCommandLineInstallationDirectory = true;
    private boolean searchForPreviousInstallation = true;
    private boolean includeAllUsers = false;
    private boolean includeUserSpecific = false;

    public InstallationScope getInstallationScope() {
        return this.replaceWithTextOverride("installationScope", this.installationScope, InstallationScope.class);
    }

    public void setInstallationScope(InstallationScope installationScope) {
        this.installationScope = installationScope;
    }

    public boolean isSkipForCommandLineInstallationDirectory() {
        return this.replaceWithTextOverride("skipForCommandLineInstallationDirectory", this.skipForCommandLineInstallationDirectory);
    }

    public void setSkipForCommandLineInstallationDirectory(boolean skipForCommandLineInstallationDirectory) {
        this.skipForCommandLineInstallationDirectory = skipForCommandLineInstallationDirectory;
    }

    public boolean isSearchForPreviousInstallation() {
        return this.replaceWithTextOverride("searchForPreviousInstallation", this.searchForPreviousInstallation);
    }

    public void setSearchForPreviousInstallation(boolean searchForPreviousInstallation) {
        this.searchForPreviousInstallation = searchForPreviousInstallation;
    }

    public boolean isIncludeAllUsers() {
        return this.replaceWithTextOverride("includeAllUsers", this.includeAllUsers);
    }

    public void setIncludeAllUsers(boolean includeAllUsers) {
        this.includeAllUsers = includeAllUsers;
    }

    public boolean isIncludeUserSpecific() {
        return this.replaceWithTextOverride("includeUserSpecific", this.includeUserSpecific);
    }

    public void setIncludeUserSpecific(boolean includeUserSpecific) {
        this.includeUserSpecific = includeUserSpecific;
    }

    @Override
    public boolean install(InstallerContext context) throws UserCanceledException {
        if (this.isSkipForCommandLineInstallationDirectory() && InstallerVariables.isInstallationDirectoryFromCommandLine()) {
            Util.logInfo(null, "Skipped because the installation directory was specified on the command line");
            return true;
        }
        InstallationScope installationScope = this.getInstallationScope();
        boolean installForAllUsers = installationScope.isInstallForAllUsers(context);
        File directory = null;
        if (this.isSearchForPreviousInstallation()) {
            directory = this.findPreviousInstallationDirectory(context, installForAllUsers);
            if (directory != null && installationScope == InstallationScope.DIRECTORY_WRITABLE && !Util.isDirectoryWritable(directory)) {
                directory = null;
            }
            if (directory == null && !installForAllUsers && this.isIncludeAllUsers() && (directory = this.findPreviousInstallationDirectory(context, true)) != null) {
                installForAllUsers = true;
            }
            if (directory == null && installForAllUsers && this.isIncludeUserSpecific() && (directory = this.findPreviousInstallationDirectory(context, false)) != null) {
                installForAllUsers = false;
            }
        }
        if (directory == null) {
            if (installForAllUsers) {
                directory = context.getAllUsersDefaultInstallationDirectory();
                if (installationScope == InstallationScope.DIRECTORY_WRITABLE && !Util.isDirectoryWritable(directory)) {
                    directory = context.getUserWritableDefaultInstallationDirectory();
                    installForAllUsers = false;
                }
            } else {
                directory = context.getUserWritableDefaultInstallationDirectory();
            }
        }
        context.setVariable("sys.installForAllUsers", installForAllUsers);
        context.setInstallationDirectory(directory);
        return true;
    }

    private File findPreviousInstallationDirectory(Context context, boolean allUsers) {
        try {
            String targetApplicationId = InstallerConfig.getCurrentInstance().getTargetApplicationId();
            String previousLocation = InstallRegistry.getInstallationDir(targetApplicationId, allUsers);
            if (previousLocation != null && !previousLocation.trim().isEmpty()) {
                File possibleTargetDir = new File(previousLocation);
                if (new File(previousLocation).getParentFile() == null) {
                    return null;
                }
                if (Boolean.getBoolean("install4j.noPreviousExistenceCheck") || CompilerVariableHelper.getCompilerExtensionVariable(context, "noPreviousExistenceCheck", false)) {
                    return possibleTargetDir;
                }
                ApplicationRegistryImpl.ApplicationInfoImpl applicationInfo = ApplicationRegistryImpl.getApplicationInfoByDir(new File(previousLocation));
                if (applicationInfo != null && Objects.equals(targetApplicationId, applicationInfo.getId())) {
                    if (Boolean.getBoolean("install4j.noPreviousBitnessCheck") || CompilerVariableHelper.getCompilerExtensionVariable(context, "noPreviousBitnessCheck", false)) {
                        return possibleTargetDir;
                    }
                    if (applicationInfo.getBitness().isCompatible()) {
                        if (!Util.isWindowsInstaller() || !CompilerVariableHelper.getCompilerExtensionVariable(context, "previousArchitectureCheck", false)) {
                            return possibleTargetDir;
                        }
                        if (Misc.getMachine() != PE32Handler.Machine.ARM64 || InstallerUtil.isAaarch64() == "windows-arm64".equals(applicationInfo.getCompilerVariable("sys.platform"))) {
                            return possibleTargetDir;
                        }
                        Logger.getInstance().info(null, "platform " + applicationInfo.getCompilerVariable("sys.platform") + " from " + previousLocation + " is not compatible");
                        return null;
                    }
                    Logger.getInstance().info(null, "bitness " + applicationInfo.getBitness() + " from " + previousLocation + " is not compatible");
                    return null;
                }
            }
        }
        catch (Throwable t) {
            Logger.getInstance().log(t);
        }
        return null;
    }
}

