/*
 * Decompiled with CFR 0.152.
 */
package com.ejt.internal.i18n;

import com.ejt.internal.i18n.HtmlResourceBundle;
import com.ejt.internal.i18n.XHTMLFragment;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class AbstractMessages {
    private static final List<AbstractMessages> allMessages = new ArrayList<AbstractMessages>();
    public static final String XHTML_EXTENSION = ".xhtml";
    private static final ResourceBundle.Control CONTROL = new UtfPropertiesControl();
    public static final boolean IGNORE_MISSING_MESSAGE = Boolean.getBoolean("ejt.ignoreMissingMessages");
    private ResourceBundle bundle;
    private HtmlResourceBundle htmlBundle;
    private Boolean isReverse;
    private Map<String, String> htmlToPlainTextBuffer = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void invalidateAll() {
        List<AbstractMessages> list = allMessages;
        synchronized (list) {
            for (AbstractMessages messages : allMessages) {
                messages.clear();
            }
        }
    }

    public static boolean isDefaultLocale() {
        return Locale.getDefault().getLanguage().equals("en");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractMessages() {
        List<AbstractMessages> list = allMessages;
        synchronized (list) {
            allMessages.add(this);
        }
    }

    protected abstract String getBundleName();

    @NotNull
    private ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = ResourceBundle.getBundle(this.getBundleName(), Locale.getDefault(), this.getClass().getClassLoader(), CONTROL);
        }
        return this.bundle;
    }

    @NotNull
    private HtmlResourceBundle getHtmlBundle() {
        if (this.htmlBundle == null) {
            this.htmlBundle = this.loadHtmlBundle();
        }
        return this.htmlBundle;
    }

    private void clear() {
        this.bundle = null;
        this.htmlBundle = null;
        this.isReverse = null;
        this.htmlToPlainTextBuffer.clear();
    }

    @NotNull
    protected String getStringInternal(@NotNull String key, Object ... args) {
        return this.applyFormat(this.getStringInternal(key), args);
    }

    @NotNull
    protected String getBoldArgumentsHtmlStringInternal(String key, Object[] args) {
        return "<html>" + this.applyFormat(this.getStringInternal(key).replaceAll("(\\{\\d})", "<b>$1</b>"), args);
    }

    @NotNull
    protected String getBoldArgumentsFormatStringInternal(String key, Object[] args) {
        return this.applyFormat(this.getStringInternal(key).replaceAll("(\\{\\d})", "#$1:b#"), this.escapeForFormatString(args)).replaceAll("#([^#]+)#", "{$1}");
    }

    private Object[] escapeForFormatString(Object[] args) {
        Object[] result = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            result[i] = arg instanceof String ? this.escapeForFormatString((String)arg) : arg;
        }
        return result;
    }

    private String escapeForFormatString(String arg) {
        return arg.replace("\\", "\\\\").replace(":", "\\:").replace("{", "\\{");
    }

    @NotNull
    private String getStringInternal(@NotNull String key) {
        return this.getString(key, this.getBundle());
    }

    @NotNull
    private String getString(@NotNull String key, ResourceBundle bundle) {
        try {
            String string = bundle.getString(key);
            if (this.isReverse == null) {
                this.isReverse = Locale.getDefault().getLanguage().equals("zz");
            }
            return this.isReverse != false ? this.reverse(string) : string;
        }
        catch (MissingResourceException e) {
            if (IGNORE_MISSING_MESSAGE) {
                return "";
            }
            throw e;
        }
    }

    @NotNull
    private String reverse(String string) {
        StringBuilder wordBuffer = new StringBuilder();
        StringBuilder buffer = new StringBuilder();
        int length = string.length();
        boolean inTag = false;
        char tagEnd = ' ';
        int choiceQuantifier = 0;
        for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            choiceQuantifier = choiceQuantifier == 0 && c == '|' ? 1 : (choiceQuantifier == 1 && Character.isDigit(c) ? 2 : (choiceQuantifier == 2 && c == '<' ? 3 : 0));
            if (!inTag && (choiceQuantifier < 3 && c == '<' || c == '{') || c == '&') {
                this.appendWord(wordBuffer, buffer);
                inTag = true;
                tagEnd = this.getTagEnd(c);
                buffer.append(c);
                continue;
            }
            if (inTag) {
                buffer.append(c);
                if (!this.isTagEnd(c, tagEnd)) continue;
                inTag = false;
                continue;
            }
            if (this.isStopChar(c) || choiceQuantifier == 3) {
                this.appendWord(wordBuffer, buffer);
                buffer.append(c);
                continue;
            }
            wordBuffer.append(c);
        }
        this.appendWord(wordBuffer, buffer);
        return buffer.toString();
    }

    private boolean isTagEnd(char c, char tagEnd) {
        return c == tagEnd || tagEnd == '}' && (c == '#' || c == '<');
    }

    private boolean isStopChar(char c) {
        if (Character.isDigit(c)) {
            return true;
        }
        switch (c) {
            case ' ': 
            case '#': 
            case '(': 
            case ')': 
            case ',': 
            case '-': 
            case '.': 
            case ':': 
            case '=': 
            case '>': 
            case '?': 
            case '[': 
            case ']': 
            case '|': 
            case '}': {
                return true;
            }
        }
        return false;
    }

    private void appendWord(StringBuilder wordBuffer, StringBuilder buffer) {
        wordBuffer.reverse();
        int length = wordBuffer.length();
        if (length > 1) {
            char lastCharacter = wordBuffer.charAt(length - 1);
            char secondLastCharacter = wordBuffer.charAt(length - 2);
            char firstCharacter = wordBuffer.charAt(0);
            if (Character.isUpperCase(lastCharacter) && Character.isLowerCase(secondLastCharacter)) {
                wordBuffer.setCharAt(0, Character.toUpperCase(firstCharacter));
                wordBuffer.setCharAt(length - 1, Character.toLowerCase(lastCharacter));
            }
        }
        buffer.append((CharSequence)wordBuffer);
        wordBuffer.setLength(0);
    }

    private char getTagEnd(char c) {
        switch (c) {
            case '<': {
                return '>';
            }
            case '{': {
                return '}';
            }
            case '&': {
                return ';';
            }
        }
        throw new IllegalStateException("Unknown tag " + c);
    }

    private String applyFormat(@NotNull String value, Object ... args) {
        if (args != null && args.length > 0 && value.contains("{")) {
            return new MessageFormat(this.removeComments(value)).format(args);
        }
        return value;
    }

    private String removeComments(String text) {
        if (text.contains("comment:")) {
            return text.replaceAll("comment:[^,}]+", "");
        }
        return text;
    }

    @XHTMLFragment
    @NotNull
    protected String htmlInternal(@NotNull String key, @XHTMLFragment @NotNull String text) {
        if (AbstractMessages.isDefaultLocale()) {
            return text;
        }
        return this.getString(key, this.getHtmlBundle());
    }

    @NotNull
    protected HtmlBuilder buildHtmlInternal(@NotNull String key, @XHTMLFragment @NotNull String text) {
        return new HtmlBuilder(this.htmlInternal(key, text));
    }

    @NotNull
    protected String textInternal(@NotNull String key, @NotNull String text) {
        if (AbstractMessages.isDefaultLocale()) {
            return text;
        }
        return this.getText(key);
    }

    @NotNull
    public String getText(@NotNull String key) {
        return this.htmlToPlainText(this.getString(key, this.getHtmlBundle()));
    }

    @NotNull
    private String htmlToPlainText(String text) {
        String cachedPlainText = this.htmlToPlainTextBuffer.get(text);
        if (cachedPlainText == null) {
            try {
                Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader("<html>" + text.replace("&nbsp;", "&#160;") + "</html>")));
                StringBuilder buffer = new StringBuilder();
                this.appendPlainText(document.getDocumentElement(), buffer);
                cachedPlainText = buffer.toString();
                this.htmlToPlainTextBuffer.put(text, cachedPlainText);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return cachedPlainText;
    }

    private void appendPlainText(Element parentElement, StringBuilder buffer) {
        NodeList childNodes = parentElement.getChildNodes();
        int nodeSize = childNodes.getLength();
        boolean firstParagraph = true;
        for (int i = 0; i < nodeSize; ++i) {
            Node node = childNodes.item(i);
            if (node instanceof Element) {
                String nodeName = node.getNodeName();
                if (nodeName.equals("p")) {
                    if (!firstParagraph) {
                        buffer.append("\n\n");
                    }
                    this.appendPlainText((Element)node, buffer);
                    firstParagraph = false;
                    continue;
                }
                if (nodeName.equals("br")) {
                    buffer.append("\n");
                    continue;
                }
                buffer.append(node.getTextContent());
                continue;
            }
            buffer.append(node.getTextContent().trim());
        }
    }

    @NotNull
    protected TextBuilder buildTextInternal(@NotNull String key, @NotNull String text) {
        return new TextBuilder(this.textInternal(key, text));
    }

    @NotNull
    private String getResourcePath() {
        return this.getBundleName().replace('.', '/').replace("/messages/", "/xhtml/") + XHTML_EXTENSION;
    }

    @NotNull
    private HtmlResourceBundle loadHtmlBundle() {
        Locale locale = Locale.getDefault();
        HtmlResourceBundle resourceBundle = this.loadHtmlBundle(this.getResourcePath(), null);
        HtmlResourceBundle languageResourceBundle = this.loadHtmlBundle(this.getLocaleResourcePath(locale.getLanguage()), resourceBundle);
        return this.loadHtmlBundle(this.getLocaleResourcePath(locale.getLanguage() + "_" + locale.getCountry()), languageResourceBundle);
    }

    @NotNull
    private HtmlResourceBundle loadHtmlBundle(String resourcePath, @Nullable HtmlResourceBundle parentBundle) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader.getResource(resourcePath) == null) {
            if (parentBundle == null) {
                throw new IllegalStateException("Resource " + resourcePath + " not found");
            }
            return parentBundle;
        }
        try {
            return new HtmlResourceBundle(classLoader.getResourceAsStream(resourcePath), parentBundle);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private String getLocaleResourcePath(String localeCode) {
        return this.getResourcePath().replace(XHTML_EXTENSION, "_" + localeCode + XHTML_EXTENSION);
    }

    private static class UtfPropertiesControl
    extends ResourceBundle.Control {
        private UtfPropertiesControl() {
        }

        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            String bundleName = this.toBundleName(baseName, locale);
            if (bundleName.contains("://")) {
                return null;
            }
            String resourceName = this.toResourceName(bundleName, "properties");
            URL url = loader.getResource(resourceName);
            if (url == null) {
                return null;
            }
            URLConnection connection = url.openConnection();
            if (reload) {
                connection.setUseCaches(false);
            }
            return new PropertyResourceBundle(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
        }
    }

    public class HtmlBuilder
    extends TextBuilder {
        private HtmlBuilder(String text) {
            super(text);
        }

        @Override
        @XHTMLFragment
        @NotNull
        public String withArgs(Object ... args) {
            return super.withArgs(args);
        }
    }

    public class TextBuilder {
        @NotNull
        private String text;

        private TextBuilder(String text) {
            this.text = text;
        }

        @XHTMLFragment
        @NotNull
        public String withArgs(Object ... args) {
            return AbstractMessages.this.applyFormat(this.text, args);
        }
    }
}

