/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.beaninfo.BeanValidationException;
import com.install4j.api.beaninfo.BeanValidator;
import com.install4j.api.beaninfo.Install4JPropertyDescriptor;
import com.install4j.api.beans.Bean;
import com.install4j.runtime.beans.BeanInfo;
import com.install4j.runtime.beans.formcomponents.FormComponentUtil;
import com.install4j.runtime.beans.formcomponents.LeadingLabelComponent;
import com.install4j.runtime.beans.formcomponents.LeadingLabelComponentBeanInfo;
import com.install4j.runtime.beans.formcomponents.UserSelectorComponent;

@BeanInfo
public class UserSelectorComponentBeanInfo
extends LeadingLabelComponentBeanInfo
implements BeanValidator {
    private static final String PROPERTY_SHOW_USERS = "showUsers";
    private static final String PROPERTY_SHOW_GROUPS = "showGroups";
    private static final String PROPERTY_SHOW_WELL_KNOWN_PRINCIPALS = "showWellKnownPrincipals";
    private static final String PROPERTY_MULTIPLE_SELECTION = "multipleSelection";
    private static final String PROPERTY_ONLY_LOCAL = "onlyLocal";
    public static final String PROPERTY_SHOW_CREATE_BUTTON = "showCreateButton";
    private static final String PROPERTY_USER_CREATED_VARIABLE_NAME = "userCreatedVariableName";
    private static final String PROPERTY_PASSWORD_FORM_COMPONENT_ID = "passwordFormComponentId";
    private static final String PROPERTY_LOCAL_GROUP_VARIABLE_NAME = "localGroupVariableName";
    private static final String PROPERTY_GROUP_CREATED_VARIABLE_NAME = "groupCreatedVariableName";

    public UserSelectorComponentBeanInfo() {
        super("Windows user selector", "A component for selecting Windows users or groups in the native Windows user dialog. Optionally, you can display a button to create a new user. The selection is saved as a <a href=\"https://en.wikipedia.org/wiki/Security_Identifier\">SID</a> to a string variable. If multiple selection is enabled, the result is a string array of SIDs.<p>This component does not do anything in console mode, since it requires the native Windows dialog for selecting users and groups.</p>", "Special selectors and displays", (Integer)null, (Class<? extends LeadingLabelComponent>)UserSelectorComponent.class);
        FormComponentUtil.addVariableDescriptor(this, "The variable value will be a string with the selected <a href=\"https://en.wikipedia.org/wiki/Security_Identifier\">SID</a>, or, if multiple selection is enabled, a string array of SIDs.", null);
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_SHOW_USERS, (Class)this.getBeanClass(), (String)"Show users", (String)"Show users in the native user selection dialog."));
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_SHOW_GROUPS, (Class)this.getBeanClass(), (String)"Show groups", (String)"Show users in the native user selection dialog."));
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_SHOW_WELL_KNOWN_PRINCIPALS, (Class)this.getBeanClass(), (String)"Show well-known principals", (String)"Show well-known principals like \"SYSTEM\" or \"SERVICE\" in the native user selection dialog."));
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_MULTIPLE_SELECTION, (Class)this.getBeanClass(), (String)"Multiple selection", (String)"If selected, multiple users or groups can be selected. The variable type is a string array of SIDs in that case, otherwise it is a string with the single selected SID. Multiple selection cannot be combined with the \"Create User\" option."));
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_ONLY_LOCAL, (Class)this.getBeanClass(), (String)"Only local objects", (String)"If selected, only local users and groups will be displayed."));
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_SHOW_CREATE_BUTTON, (Class)this.getBeanClass(), (String)"Show \"Create User\" button", (String)"If selected, a button to create a new user will be displayed next to the \"Browse\" button. On clicking that button, a separate dialog will be shown where the new user can be configured.").setParentProperty(PROPERTY_SHOW_USERS));
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_USER_CREATED_VARIABLE_NAME, (Class)this.getBeanClass(), (String)"Variable for user creation flag", (String)"The name of the variable which will be set to <tt>Boolean.TRUE</tt> if the selected user has been created by the user. If the selected user has not been created, the variable value will be set to <tt>Boolean.FALSE</tt>. This is useful if you would like to determine if the uninstaller should delete the user. Users can be deleted with the install4j API.<p>This variable name can be empty, in which case the creation status will not be saved.</p>", (String)"variableName").setVariableValueClass(Boolean.class).setParentProperty(PROPERTY_SHOW_CREATE_BUTTON));
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_LOCAL_GROUP_VARIABLE_NAME, (Class)this.getBeanClass(), (String)"Variable for local group", (String)"The name of the variable which will be set to the local group used for a newly created user. This variable name can be empty, in which case the created local group name will not be saved.", (String)"variableName").setVariableValueClass(String.class).setParentProperty(PROPERTY_SHOW_CREATE_BUTTON));
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_GROUP_CREATED_VARIABLE_NAME, (Class)this.getBeanClass(), (String)"Variable for group creation flag", (String)"The name of the variable which will be set to <tt>Boolean.TRUE</tt> if a group for the selected user has been created by the user. If the selected user has not been created or if an existing group was used, the variable value will be set to <tt>Boolean.FALSE</tt>. This is useful if you would like to determine if the uninstaller should delete the local group. Groups can be deleted with the install4j API.<p>This variable name can be empty, in which case the creation status will not be saved.</p>", (String)"variableName").setVariableValueClass(Boolean.class).setParentProperty(PROPERTY_SHOW_CREATE_BUTTON));
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_PASSWORD_FORM_COMPONENT_ID, (Class)this.getBeanClass(), (String)"Password form component", (String)"A text field or password field form component that should be updated with the password that was chosen for the created user. If not selected, no such update will be performed.", (String)"formComponent").setParentProperty(PROPERTY_SHOW_CREATE_BUTTON));
        this.setDefaultVisibilityScript("Util.isWindows()");
    }

    @Override
    public void validateBean(Bean bean) throws BeanValidationException {
        super.validateBean(bean);
        FormComponentUtil.validateVariable(bean, this);
        if (Boolean.TRUE.equals(this.getPropertyValue(PROPERTY_SHOW_CREATE_BUTTON, bean)) && Boolean.TRUE.equals(this.getPropertyValue(PROPERTY_MULTIPLE_SELECTION, bean))) {
            throw new BeanValidationException("Multiple selection cannot be combined with the \"Create User\" option.", PROPERTY_MULTIPLE_SELECTION);
        }
    }
}

