/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.e.c;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.crypto.Cipher;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;

public final class a {
    public static void a(String[] stringArray) throws Exception {
        Iterator iterator;
        if (stringArray.length < 1) {
            System.err.println("Usage: AuthenticodeSigDebug <sig.bin|sig.p7b> [file.exe]");
            System.exit(2);
        }
        Security.addProvider((Provider)new BouncyCastleProvider());
        Path path = Path.of(stringArray[0], new String[0]);
        Path path2 = stringArray.length >= 2 ? Path.of(stringArray[1], new String[0]) : null;
        byte[] byArray = Files.readAllBytes(path);
        if (byArray.length > 8 && byArray[0] != 48 && byArray[8] == 48) {
            byArray = Arrays.copyOfRange(byArray, 8, byArray.length);
            System.out.println("Detected WIN_CERTIFICATE wrapper; stripped first 8 bytes.");
        }
        CMSSignedData cMSSignedData = new CMSSignedData(byArray);
        System.out.println("CMS ContentType OID: " + cMSSignedData.getSignedContentTypeOID());
        System.out.println("Has encapsulated content: " + (cMSSignedData.getSignedContent() != null));
        Store store = cMSSignedData.getCertificates();
        SignerInformationStore signerInformationStore = cMSSignedData.getSignerInfos();
        System.out.println("Signer count: " + signerInformationStore.size());
        byte[] byArray2 = null;
        if (cMSSignedData.getSignedContent() != null && (iterator = cMSSignedData.getSignedContent().getContent()) instanceof byte[]) {
            byArray2 = (byte[])iterator;
        }
        for (SignerInformation signerInformation : signerInformationStore.getSigners()) {
            byte[] byArray3;
            Object object;
            System.out.println();
            System.out.println("=== Signer ===");
            System.out.println("DigestAlgOID: " + signerInformation.getDigestAlgOID() + " (" + a.a(signerInformation.getDigestAlgOID()) + ")");
            System.out.println("EncryptionAlgOID: " + signerInformation.getEncryptionAlgOID());
            byte[] byArray4 = signerInformation.getEncryptionAlgParams();
            System.out.println("EncryptionAlgParams: " + (String)(byArray4 == null ? "<none>" : "len=" + byArray4.length));
            X509Certificate x509Certificate = a.a((Store<X509CertificateHolder>)store, signerInformation);
            if (x509Certificate != null) {
                System.out.println("Cert Subject: " + String.valueOf(x509Certificate.getSubjectX500Principal()));
                System.out.println("Cert Issuer : " + String.valueOf(x509Certificate.getIssuerX500Principal()));
                System.out.println("Cert Serial : " + x509Certificate.getSerialNumber().toString(16));
            } else {
                System.out.println("Cert: <not found in CMS cert set for this SignerIdentifier>");
            }
            byte[] byArray5 = a.a(signerInformation.getSignedAttributes());
            if (byArray5 != null) {
                System.out.println("signedAttrs messageDigest: " + a.b(byArray5));
            } else {
                System.out.println("signedAttrs messageDigest: <missing>");
            }
            if (byArray2 != null && byArray5 != null) {
                object = MessageDigest.getInstance(a.a(signerInformation.getDigestAlgOID()));
                byArray3 = ((MessageDigest)object).digest(byArray2);
                System.out.println("digest(encapContent)      : " + a.b(byArray3));
                System.out.println("messageDigest matches?    : " + MessageDigest.isEqual(byArray5, byArray3));
            }
            if (x509Certificate != null) {
                boolean bl2;
                try {
                    bl2 = signerInformation.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(x509Certificate));
                }
                catch (Exception exception) {
                    bl2 = false;
                    System.out.println("Signer verify threw: " + exception.getClass().getName() + ": " + exception.getMessage());
                }
                System.out.println("Signer verifies?          : " + bl2);
                if (!bl2) {
                    a.a(signerInformation, x509Certificate);
                }
            }
            if (byArray2 == null) continue;
            object = a.a(byArray2);
            if (object != null) {
                System.out.println("SpcIndirectDataContent digestAlgOID: " + ((a)object).a + " (" + a.a(((a)object).a) + ")");
                System.out.println("SpcIndirectDataContent digest      : " + a.b(((a)object).b));
                if (path2 == null) continue;
                byArray3 = a.a(path2, ((a)object).a);
                System.out.println("Computed PE authentihash           : " + a.b(byArray3));
                System.out.println("PE hash matches embedded?          : " + MessageDigest.isEqual(((a)object).b, byArray3));
                continue;
            }
            System.out.println("SpcIndirectDataContent: <could not parse>");
        }
    }

    private static X509Certificate a(Store<X509CertificateHolder> store, SignerInformation signerInformation) throws Exception {
        Collection collection = store.getMatches((Selector)signerInformation.getSID());
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        X509CertificateHolder x509CertificateHolder = (X509CertificateHolder)collection.iterator().next();
        return new JcaX509CertificateConverter().setProvider("BC").getCertificate(x509CertificateHolder);
    }

    private static byte[] a(AttributeTable attributeTable) {
        if (attributeTable == null) {
            return null;
        }
        Attribute attribute = attributeTable.get(CMSAttributes.messageDigest);
        if (attribute == null) {
            return null;
        }
        ASN1Encodable aSN1Encodable = attribute.getAttrValues().getObjectAt(0);
        return ASN1OctetString.getInstance((Object)aSN1Encodable).getOctets();
    }

    private static a a(byte[] byArray) {
        try {
            ASN1Primitive aSN1Primitive = ASN1Primitive.fromByteArray((byte[])byArray);
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((Object)aSN1Primitive);
            if (aSN1Sequence.size() < 2) {
                return null;
            }
            ASN1Sequence aSN1Sequence2 = ASN1Sequence.getInstance((Object)aSN1Sequence.getObjectAt(1));
            AlgorithmIdentifier algorithmIdentifier = AlgorithmIdentifier.getInstance((Object)aSN1Sequence2.getObjectAt(0));
            byte[] byArray2 = ASN1OctetString.getInstance((Object)aSN1Sequence2.getObjectAt(1)).getOctets();
            return new a(algorithmIdentifier.getAlgorithm().getId(), byArray2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static byte[] a(Path path, String string) throws IOException {
        MessageDigest messageDigest;
        String string2 = a.a(string);
        try {
            messageDigest = MessageDigest.getInstance(string2);
        }
        catch (Exception exception) {
            throw new IOException("Unsupported digest OID for MessageDigest: " + string, exception);
        }
        try (FileChannel fileChannel = FileChannel.open(path, StandardOpenOption.READ);){
            long l2;
            long l3;
            long l4;
            long l5 = fileChannel.size();
            int n2 = (int)a.a(fileChannel, 60L);
            long l6 = Integer.toUnsignedLong(n2);
            int n3 = (int)a.a(fileChannel, l6);
            if (n3 != 17744) {
                throw new IOException("Not a PE file (missing PE\\0\\0 signature).");
            }
            int n4 = a.b(fileChannel, l6 + 4L + 2L);
            int n5 = a.b(fileChannel, l6 + 4L + 16L);
            long l7 = l6 + 4L + 20L;
            byte[] byArray = a.a(fileChannel, l7, n5);
            b b2 = a.a(byArray, l7);
            long l8 = l7 + (long)n5;
            long l9 = 0L;
            for (int i2 = 0; i2 < n4; ++i2) {
                long l10 = l8 + (long)i2 * 40L;
                l4 = a.a(fileChannel, l10 + 16L);
                l3 = a.a(fileChannel, l10 + 20L);
                l2 = l3 + l4;
                if (l2 <= l9) continue;
                l9 = l2;
            }
            long l11 = Math.min(l9, l5);
            List<long[]> list = new ArrayList<long[]>();
            list.add(new long[]{b2.a, b2.a + 4L});
            list.add(new long[]{b2.b, b2.b + 8L});
            if (b2.c > 0L && b2.d > 0L) {
                l4 = b2.c;
                l3 = l4 + b2.d;
                if (l4 < l11) {
                    list.add(new long[]{l4, Math.min(l3, l11)});
                }
            }
            list.sort(Comparator.comparingLong(lArray -> lArray[0]));
            list = a.a(list);
            l4 = 0L;
            for (long[] lArray2 : list) {
                l2 = a.a(lArray2[0], 0L, l11);
                long l12 = a.a(lArray2[1], 0L, l11);
                if (l4 < l2) {
                    a.a(fileChannel, messageDigest, l4, l2);
                }
                l4 = Math.max(l4, l12);
            }
            if (l4 < l11) {
                a.a(fileChannel, messageDigest, l4, l11);
            }
            Object object = messageDigest.digest();
            return object;
        }
    }

    private static b a(byte[] byArray, long l2) throws IOException {
        boolean bl2;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN);
        int n2 = Short.toUnsignedInt(byteBuffer.getShort());
        if (n2 == 267) {
            bl2 = false;
        } else if (n2 == 523) {
            bl2 = true;
        } else {
            throw new IOException("Unknown OptionalHeader magic: 0x" + Integer.toHexString(n2));
        }
        byteBuffer.position(byteBuffer.position() + 2);
        byteBuffer.position(byteBuffer.position() + 20);
        if (!bl2) {
            byteBuffer.position(byteBuffer.position() + 4);
        }
        byteBuffer.position(byteBuffer.position() + (bl2 ? 8 : 4));
        byteBuffer.position(byteBuffer.position() + 8);
        byteBuffer.position(byteBuffer.position() + 12);
        byteBuffer.position(byteBuffer.position() + 12);
        int n3 = byteBuffer.position();
        byteBuffer.position(byteBuffer.position() + 4);
        byteBuffer.position(byteBuffer.position() + 2 + 2);
        byteBuffer.position(byteBuffer.position() + (bl2 ? 8 : 4) * 4);
        byteBuffer.position(byteBuffer.position() + 4);
        int n4 = byteBuffer.getInt();
        int n5 = byteBuffer.position();
        int n6 = 4;
        int n7 = n5 + n6 * 8;
        if (n4 < n6 + 1 || n7 + 8 > byArray.length) {
            throw new IOException("OptionalHeader has no security data directory entry.");
        }
        ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray, n7, 8).order(ByteOrder.LITTLE_ENDIAN);
        long l3 = Integer.toUnsignedLong(byteBuffer2.getInt());
        long l4 = Integer.toUnsignedLong(byteBuffer2.getInt());
        return new b(l2 + (long)n3, l2 + (long)n7, l3, l4);
    }

    private static void a(FileChannel fileChannel, MessageDigest messageDigest, long l2, long l3) throws IOException {
        int n2;
        long l4 = l2;
        ByteBuffer byteBuffer = ByteBuffer.allocate(131072);
        for (long i2 = l3 - l2; i2 > 0L; i2 -= (long)n2) {
            byteBuffer.clear();
            int n3 = (int)Math.min((long)byteBuffer.capacity(), i2);
            byteBuffer.limit(n3);
            n2 = fileChannel.read(byteBuffer, l4);
            if (n2 <= 0) {
                throw new IOException("Unexpected EOF while hashing at pos=" + l4);
            }
            byteBuffer.flip();
            messageDigest.update(byteBuffer);
            l4 += (long)n2;
        }
    }

    private static List<long[]> a(List<long[]> list) {
        if (list.isEmpty()) {
            return list;
        }
        ArrayList<long[]> arrayList = new ArrayList<long[]>();
        long[] lArray = (long[])list.getFirst().clone();
        for (int i2 = 1; i2 < list.size(); ++i2) {
            long[] lArray2 = list.get(i2);
            if (lArray2[0] <= lArray[1]) {
                lArray[1] = Math.max(lArray[1], lArray2[1]);
                continue;
            }
            arrayList.add(lArray);
            lArray = (long[])lArray2.clone();
        }
        arrayList.add(lArray);
        return arrayList;
    }

    private static long a(long l2, long l3, long l4) {
        return Math.max(l3, Math.min(l4, l2));
    }

    private static long a(FileChannel fileChannel, long l2) throws IOException {
        byte[] byArray = a.a(fileChannel, l2, 4);
        return Integer.toUnsignedLong(ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getInt());
    }

    private static int b(FileChannel fileChannel, long l2) throws IOException {
        byte[] byArray = a.a(fileChannel, l2, 2);
        return Short.toUnsignedInt(ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getShort());
    }

    private static byte[] a(FileChannel fileChannel, long l2, int n2) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        int n3 = fileChannel.read(byteBuffer, l2);
        if (n3 != n2) {
            throw new IOException("Short read at pos=" + l2 + " (got " + n3 + ", need " + n2 + ")");
        }
        return byteBuffer.array();
    }

    private static String a(String string) {
        return switch (string) {
            case "1.3.14.3.2.26" -> "SHA-1";
            case "2.16.840.1.101.3.4.2.1" -> "SHA-256";
            case "2.16.840.1.101.3.4.2.2" -> "SHA-384";
            case "2.16.840.1.101.3.4.2.3" -> "SHA-512";
            default -> string;
        };
    }

    private static String b(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        for (byte by2 : byArray) {
            stringBuilder.append(Character.forDigit(by2 >>> 4 & 0xF, 16)).append(Character.forDigit(by2 & 0xF, 16));
        }
        return stringBuilder.toString();
    }

    private static void a(SignerInformation signerInformation, X509Certificate x509Certificate) throws Exception {
        int n2;
        byte[] byArray;
        byte[] byArray2 = signerInformation.getSignature();
        byte[] byArray3 = signerInformation.getEncodedSignedAttributes();
        System.out.println("SignerId: " + String.valueOf(signerInformation.getSID()));
        System.out.println("DigestAlgOID: " + signerInformation.getDigestAlgOID());
        System.out.println("EncryptionAlgOID: " + signerInformation.getEncryptionAlgOID());
        System.out.println("EncryptionAlgParams len: " + (signerInformation.getEncryptionAlgParams() == null ? 0 : signerInformation.getEncryptionAlgParams().length));
        System.out.println("signature len: " + byArray2.length);
        System.out.println("signedAttrs DER len: " + byArray3.length);
        System.out.println("SHA-256(signature): " + a.b(a.c(byArray2)));
        System.out.println("SHA-256(signedAttrsDER): " + a.b(a.c(byArray3)));
        String string = a.a(signerInformation.getDigestAlgOID());
        byte[] byArray4 = MessageDigest.getInstance(string).digest(byArray3);
        System.out.println("digest(signedAttrsDER) [" + string + "]: " + a.b(byArray4));
        PublicKey publicKey = x509Certificate.getPublicKey();
        if (!(publicKey instanceof RSAPublicKey)) {
            System.out.println("Not an RSA public key (" + publicKey.getAlgorithm() + "), skipping RSA padding debug.");
            return;
        }
        RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
        int n3 = (rSAPublicKey.getModulus().bitLength() + 7) / 8;
        if (byArray2.length != n3) {
            byArray = new byte[n3];
            System.arraycopy(byArray2, 0, byArray, n3 - byArray2.length, byArray2.length);
            byArray2 = byArray;
            System.out.println("Signature was not modulus-sized; left-padded to " + n3 + " bytes.");
        }
        byArray = a.a(rSAPublicKey, byArray2);
        System.out.println("EM[0..15]: " + a.b(Arrays.copyOf(byArray, 16)));
        if (byArray.length < 16 || byArray[0] != 0 || byArray[1] != 1) {
            System.out.println("Not PKCS#1 v1.5 type-1 padding (expected 00 01 ...).");
            System.out.println("Likely causes: wrong signer cert/key, RSA-PSS vs v1.5 mismatch, or corrupted signature bytes.");
            return;
        }
        for (n2 = 2; n2 < byArray.length && byArray[n2] == -1; ++n2) {
        }
        if (n2 >= byArray.length || byArray[n2] != 0) {
            System.out.println("Bad PKCS#1 v1.5 padding: missing 00 separator after FF padding.");
            return;
        }
        byte[] byArray5 = Arrays.copyOfRange(byArray, ++n2, byArray.length);
        System.out.println("DigestInfo DER starts: " + a.b(Arrays.copyOf(byArray5, Math.min(16, byArray5.length))));
        try {
            DigestInfo digestInfo = DigestInfo.getInstance((Object)ASN1Primitive.fromByteArray((byte[])byArray5));
            AlgorithmIdentifier algorithmIdentifier = digestInfo.getAlgorithmId();
            byte[] byArray6 = digestInfo.getDigest();
            System.out.println("DigestInfo alg OID: " + algorithmIdentifier.getAlgorithm().getId());
            System.out.println("DigestInfo digest : " + a.b(byArray6));
            System.out.println("Digest matches digest(signedAttrsDER)? " + MessageDigest.isEqual(byArray6, byArray4));
        }
        catch (Exception exception) {
            System.out.println("Could not parse DigestInfo from recovered block: " + String.valueOf(exception));
        }
    }

    private static byte[] a(RSAPublicKey rSAPublicKey, byte[] byArray) {
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/NoPadding");
            try {
                cipher.init(2, rSAPublicKey);
            }
            catch (Exception exception) {
                cipher.init(1, rSAPublicKey);
            }
            return cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            BigInteger bigInteger = new BigInteger(1, byArray);
            BigInteger bigInteger2 = bigInteger.modPow(rSAPublicKey.getPublicExponent(), rSAPublicKey.getModulus());
            int n2 = (rSAPublicKey.getModulus().bitLength() + 7) / 8;
            byte[] byArray2 = bigInteger2.toByteArray();
            if (byArray2.length == n2) {
                return byArray2;
            }
            byte[] byArray3 = new byte[n2];
            System.arraycopy(byArray2, 0, byArray3, n2 - byArray2.length, byArray2.length);
            return byArray3;
        }
    }

    private static byte[] c(byte[] byArray) throws Exception {
        return MessageDigest.getInstance("SHA-256").digest(byArray);
    }

    private static final class a {
        final String a;
        final byte[] b;

        a(String string, byte[] byArray) {
            this.a = string;
            this.b = byArray;
        }
    }

    private static final class b {
        final long a;
        final long b;
        final long c;
        final long d;

        b(long l2, long l3, long l4, long l5) {
            this.a = l2;
            this.b = l3;
            this.c = l4;
            this.d = l5;
        }
    }
}

