/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.fileinst;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.Util;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.unix.UnixFileSystem;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.content.ContentInstaller;
import com.install4j.runtime.installer.helper.fileinst.BackupPair;
import com.install4j.runtime.installer.helper.fileinst.FileInstallerState;
import com.install4j.runtime.installer.helper.fileinst.FileLogger;
import com.install4j.runtime.installer.helper.fileinst.InstallFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class MainFileInstallerState
extends FileInstallerState {
    private transient File logDir;
    private transient FileLogger newFileLogger = new FileLogger();
    private transient FileLogger oldFileLogger = new FileLogger();
    private transient FileLogger rollbackFileLogger = new FileLogger();
    private transient List<File> cleanupFiles = new ArrayList<File>();
    private transient boolean hasUnrollbackedFiles = false;
    private transient boolean currentRebootRequired = false;
    private transient boolean fileRollbackPerformed = false;

    MainFileInstallerState() {
    }

    @Override
    public void addCreatedDir(InstallFile installFile) {
        this.newFileLogger.addCreatedDir(installFile, this.currentId);
        this.rollbackFileLogger.addCreatedDir(installFile, this.currentId);
    }

    @Override
    public void addReplacedFile(BackupPair backupPair) {
        this.newFileLogger.addReplacedFile(backupPair, this.currentId);
        this.rollbackFileLogger.addReplacedFile(backupPair, this.currentId);
    }

    @Override
    public void setRollbackBarrier() {
        if (!this.hasUnrollbackedFiles) {
            this.hasUnrollbackedFiles = this.rollbackFileLogger.hasFiles();
        }
        this.rollbackFileLogger = new FileLogger();
    }

    @Override
    public void setLogDir(File logDir) {
        if (this.logDir == null) {
            this.logDir = logDir;
            try {
                this.oldFileLogger.read(new File(logDir, "files.log"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void writeLog() throws IOException, UserCanceledException {
        if (this.newFileLogger.hasFiles()) {
            File logFile = new File(this.logDir, "files.log");
            File tempFile = File.createTempFile("i4jf", ".log");
            this.newFileLogger.write(tempFile, this.oldFileLogger);
            String accessMode = System.getProperty("install4j.runtimeAccessMode");
            HelperCommunication.getInstance().runActionChecked(ContentInstaller.getExecutionContext(), context -> {
                try {
                    FileUtil.copyFile(tempFile, logFile);
                    if (accessMode != null && !Util.isWindows()) {
                        UnixFileSystem.setMode(accessMode, logFile);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!tempFile.delete()) {
                    tempFile.deleteOnExit();
                }
            });
        }
    }

    @Override
    public boolean wasPreviouslyCreated(File destFile) {
        return this.oldFileLogger.containsCreatedFile(destFile);
    }

    @Override
    public boolean hasRollbackFiles() {
        return this.rollbackFileLogger.hasFiles();
    }

    @Override
    public boolean hasUnrollbackedFiles() {
        return this.hasUnrollbackedFiles;
    }

    @Override
    public void addCreatedFile(InstallFile destFile, boolean registerRollback) {
        this.newFileLogger.addCreatedFile(destFile, this.currentId, false);
        if (registerRollback) {
            this.rollbackFileLogger.addCreatedFile(destFile, this.currentId, false);
        }
    }

    @Override
    public FileLogger getRollbackFileLogger() {
        return this.rollbackFileLogger;
    }

    @Override
    public List<BackupPair> getReplacedFiles() {
        return this.newFileLogger.getReplacedFiles(-1);
    }

    @Override
    public List<File> getCleanupFiles() {
        return this.cleanupFiles;
    }

    @Override
    public void registerCleanupFile(File file) {
        this.cleanupFiles.add(file);
    }

    @Override
    public void registerPreUninstallCommand(File file, boolean adminRights, String executable, String[] arguments) {
        file = file.getAbsoluteFile();
        InstallFile.Command command = new InstallFile.Command(adminRights, executable, arguments);
        this.newFileLogger.registerPreUninstallCommand(file, command);
        this.rollbackFileLogger.registerPreUninstallCommand(file, command);
    }

    @Override
    public boolean isCurrentRebootRequired() {
        return this.currentRebootRequired;
    }

    @Override
    public void setCurrentRebootRequired(boolean val) {
        if (Util.isWindows()) {
            this.currentRebootRequired = val;
        }
    }

    @Override
    public void setFileRollbackPerformed(boolean fileRollbackPerformed) {
        this.fileRollbackPerformed = fileRollbackPerformed;
    }

    @Override
    public boolean isFileRollbackPerformed() {
        return this.fileRollbackPerformed;
    }
}

