/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.filechooser;

import com.install4j.runtime.beans.formcomponents.WidgetStyleHandlerImpl;
import com.install4j.runtime.filechooser.FileChooserQuestion;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.util.StandardDialog;
import java.awt.Window;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

class FileChooserQuestionsDialog
extends StandardDialog {
    private final Collection<FileChooserQuestion> fileChooserQuestions;
    private final Map<FileChooserQuestion, JCheckBox> checkboxes = new HashMap<FileChooserQuestion, JCheckBox>();

    public FileChooserQuestionsDialog(Window parentWindow, Collection<FileChooserQuestion> fileChooserQuestions) {
        super(parentWindow);
        this.fileChooserQuestions = fileChooserQuestions;
        this.init();
    }

    @Override
    protected void addScreenContent(JPanel panel) {
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(new JLabel(Messages.getString(".SelectFileOptions")));
        panel.add(Box.createVerticalStrut(GUIHelper.scale(8)));
        for (FileChooserQuestion fileChooserQuestion : this.fileChooserQuestions) {
            JCheckBox checkBox = new JCheckBox(fileChooserQuestion.getDescription(), fileChooserQuestion.isSelected());
            this.checkboxes.put(fileChooserQuestion, checkBox);
            panel.add(WidgetStyleHandlerImpl.getDefaultInstance().applyWidgetStyle(checkBox));
        }
    }

    @Override
    protected void setupComponent() {
        super.setupComponent();
        this.setTitle(Messages.getString(".FileOptionsTitle"));
    }

    @Override
    protected void doOk() {
        this.checkboxes.forEach((fileChooserQuestion, checkBox) -> fileChooserQuestion.setSelected(checkBox.isSelected()));
        super.doOk();
    }

    @Override
    protected boolean isFillVertical() {
        return false;
    }

    @Override
    protected int getFrameHeight() {
        return -1;
    }

    @Override
    protected int getFrameWidth() {
        return -200;
    }
}

