package com.install4j.api.screens;

import com.install4j.api.context.UninstallerContext;

/**
 * All uninstaller screens must implement this interface. You have to override all methods and provide a public constructor with no arguments.
 * It is recommended that you choose one of the derived abstract classes as a superclass.
 *
 * @author ej-technologies GmbH
 */
public interface UninstallerScreen extends Screen {

    /**
     * This method is called by the framework to set the  {@code UninstallerContext}.
     * @param context the uninstaller context.
     */
    void setUninstallerContext(UninstallerContext context);

}
