package com.install4j.api.context;

/**
 * Enumeration class that represents the different types of launchers. The constants correspond to the different launcher types that
 * you can define in the install4j GUI.
 * @author ej-technologies GmbH
 * @see LauncherSetup#getType()
 */
public enum LauncherType  {

    /**
     * Represents a console launcher.
     */
    CONSOLE("console"),

    /**
     * Represents a GUI launcher.
     */
    GUI("gui"),

    /**
     * Represents a service launcher.
     */
    SERVICE("service"),

    /**
     * Represents an external launcher.
     */
    EXTERNAL("external"),

    /**
     * Represents a custom installer application.
     */
    INSTALLER_APPLICATION("installer application");

    private final transient String verbose;

    LauncherType(String verbose) {
        this.verbose = verbose;
    }

    @Override
    public String toString() {
        return verbose;
    }
}
