package com.install4j.api.context;

/**
 * This interface provides information about installation components.
 * Installation components are configured on the "Installation Components" tab
 * in the install4j IDE.
 * <p>Objects of this type are returned by {@link Context#getInstallationComponents()} and {@link Context#getInstallationComponentById(String)}
 *
 * @author ej-technologies GmbH
 */
public interface InstallationComponentSetup {

    /**
     * Returns whether the installation components have been selected by the user.
     *
     * @return {@code true} or {@code false}.
     */
    boolean isSelected();

    /**
     * Sets whether the installation component should be installed or not. This method only has an effect
     * when called before the "Install files" action.
     *
     * @param selected the new selection state
     */
    void setSelected(boolean selected);

    /**
     * Returns whether the selection state of the installation component can be changed by the user or not.
     *
     * @return {@code true} or {@code false}.
     */
    boolean isChangeable();

    /**
     * Sets whether the selection state of the installation component can be changed by the user or not.
     *
     * @param changeable the new state
     */
    void setChangeable(boolean changeable);

    /**
     * Returns whether the installation component is hidden from the user. This only affects the display in the
     * component tree.
     *
     * @return {@code true} or {@code false}.
     */
    boolean isHidden();

    /**
     * Sets whether the installation component is hidden. This only affects the display in the
     * component tree.
     *
     * @param hidden the new state
     */
    void setHidden(boolean hidden);

    /**
     * Returns the name of this installation components. This is the name that you have
     * specified in the install4j IDE. The checkbox in the installation component tree displays this
     * name.
     *
     * @return the name
     */
    String getName();

    /**
     * The ID of the installation component. You can display
     * component IDs in the install4j IDE.
     *
     * @return the ID
     */
    String getId();

    /**
     * Returns whether the installation component is downloaded.
     * @return {@code true} or {@code false}.
     */
    boolean isDownloaded();
}
