package com.install4j.api.beans;

/**
 * Exception that is thrown by the {@code replaceVariables(...)} methods in {@link AbstractBean} if a
 * variable cannot be found the {@link VariableErrorHandling} for the corresponding variable type is
 * {@link VariableErrorHandling#EXCEPTION}.
 *
 * @author ej-technologies GmbH
 */
public class UndefinedVariableException extends RuntimeException {

    /**
     * Will be called by the framework with the offending variable name as the message.
     * @param variableName the name of the variable that cannot be found
     */
    public UndefinedVariableException(String variableName) {
        super(variableName);
    }

}
