package com.install4j.api.beaninfo;

/**
 * A project report element contributed by a customizer. All regular properties of your beans that have
 * a non-empty display name are included in the project report. Properties that have empty
 * display names can be used in customizers. If your customizer implements {@link CustomizerCallback},
 * it can contribute multiple entries to the project report.
 * @see CustomizerCallback#getProjectReportProperties()
 */
public class ProjectReportProperty {

    private String propertyName;
    private String reportValue;

    /**
     * Construct a project report property with a property name and a report value.
     * The property name should be the same as the name of the customizer.
     * @param propertyName the name
     * @param reportValue the description
     * @see Install4JBeanInfo#Install4JBeanInfo(String, String, String, boolean, boolean, Integer, Class, Class)
     */
    public ProjectReportProperty(String propertyName, String reportValue) {
        this.propertyName = propertyName;
        this.reportValue = reportValue;
    }

    /**
     * Get the property name.
     * @return the property name
     */
    public String getPropertyName() {
        return propertyName;
    }

    /**
     * Set the property name.
     * @param propertyName the property name
     */
    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    /**
     * Get the report value.
     * @return the report value
     */
    public String getReportValue() {
        return reportValue;
    }

    /**
     * Set the report value.
     * @param reportValue the report value
     */
    public void setReportValue(String reportValue) {
        this.reportValue = reportValue;
    }
}
