/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class Sticky {
    private JComponent _target;
    private static final StickyMouseMotionListener STICKY_MOUSE_MOTION_LISTENER = new StickyMouseMotionListener();

    public Sticky(JList jList) {
        this._target = jList;
        this.install();
    }

    public Sticky(JTree jTree) {
        this._target = jTree;
        this.install();
    }

    public Sticky(JTable jTable) {
        this._target = jTable;
        this.install();
    }

    public void install() {
        this._target.addMouseMotionListener(STICKY_MOUSE_MOTION_LISTENER);
    }

    public void uninstall() {
        this._target.removeMouseMotionListener(STICKY_MOUSE_MOTION_LISTENER);
    }

    private static void updateListSelectionForEvent(MouseEvent mouseEvent, JList jList, boolean bl2) {
        Point point = mouseEvent.getPoint();
        if (jList == null) {
            return;
        }
        int n2 = jList.locationToIndex(point);
        if (n2 == -1) {
            if (point.y < 0) {
                n2 = 0;
            } else {
                int n3 = n2 = jList.getModel() == null ? 0 : jList.getModel().getSize() - 1;
            }
        }
        if (jList.getSelectedIndex() != n2 && n2 >= 0 && n2 < jList.getModel().getSize()) {
            jList.setSelectedIndex(n2);
            if (bl2) {
                jList.ensureIndexIsVisible(n2);
            }
        }
    }

    private static void updateTreeSelectionForEvent(MouseEvent mouseEvent, JTree jTree, boolean bl2) {
        Point point = mouseEvent.getPoint();
        if (jTree == null) {
            return;
        }
        int n2 = jTree.getRowForLocation(point.x, point.y);
        if (n2 != -1) {
            TreePath treePath = jTree.getPathForRow(n2);
            if (jTree.getSelectionPath() != treePath) {
                jTree.setSelectionRow(n2);
                if (bl2) {
                    jTree.makeVisible(treePath);
                }
            }
        }
    }

    private static void updateTableSelectionForEvent(MouseEvent mouseEvent, JTable jTable, boolean bl2) {
        Point point = mouseEvent.getPoint();
        if (jTable == null) {
            return;
        }
        int n2 = jTable.rowAtPoint(point);
        if (n2 == -1) {
            if (point.y < 0) {
                n2 = 0;
            } else {
                int n3 = n2 = jTable.getModel() == null ? 0 : jTable.getModel().getRowCount() - 1;
            }
        }
        if (jTable.getSelectedRow() != n2) {
            jTable.getSelectionModel().setSelectionInterval(n2, n2);
            if (bl2) {
                JideSwingUtilities.ensureRowVisible(jTable, n2);
            }
        }
    }

    private static class StickyMouseMotionListener
    extends MouseMotionAdapter {
        private StickyMouseMotionListener() {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() instanceof JList) {
                JList jList = (JList)mouseEvent.getSource();
                Point point = mouseEvent.getPoint();
                Rectangle rectangle = new Rectangle();
                jList.computeVisibleRect(rectangle);
                if (rectangle.contains(point)) {
                    Sticky.updateListSelectionForEvent(mouseEvent, jList, false);
                }
            } else if (mouseEvent.getSource() instanceof JTree) {
                JTree jTree = (JTree)mouseEvent.getSource();
                Point point = mouseEvent.getPoint();
                Rectangle rectangle = new Rectangle();
                jTree.computeVisibleRect(rectangle);
                if (rectangle.contains(point)) {
                    Sticky.updateTreeSelectionForEvent(mouseEvent, jTree, false);
                }
            } else if (mouseEvent.getSource() instanceof JTable) {
                JTable jTable = (JTable)mouseEvent.getSource();
                Point point = mouseEvent.getPoint();
                Rectangle rectangle = new Rectangle();
                jTable.computeVisibleRect(rectangle);
                if (rectangle.contains(point)) {
                    Sticky.updateTableSelectionForEvent(mouseEvent, jTable, false);
                }
            }
        }
    }
}

