/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.CheckBoxTreeCellRenderer;
import com.jidesoft.swing.CheckBoxTreeSelectionModel;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.TristateCheckBox;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Position;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CheckBoxTree
extends JTree {
    public static final String PROPERTY_CHECKBOX_ENABLED = "checkBoxEnabled";
    public static final String PROPERTY_CLICK_IN_CHECKBOX_ONLY = "clickInCheckBoxOnly";
    public static final String PROPERTY_DIG_IN = "digIn";
    protected CheckBoxTreeCellRenderer _treeCellRenderer;
    private CheckBoxTreeSelectionModel _checkBoxTreeSelectionModel;
    private boolean _checkBoxEnabled = true;
    private boolean _clickInCheckBoxOnly = true;
    private PropertyChangeListener _modelChangeListener;
    private TristateCheckBox _checkBox;
    private boolean _selectPartialOnToggling = true;
    private TreeCellRenderer _defaultRenderer;

    public CheckBoxTree() {
        this.init();
    }

    public CheckBoxTree(Object[] objectArray) {
        super(objectArray);
        this.init();
    }

    public CheckBoxTree(Vector<?> vector) {
        super(vector);
        this.init();
    }

    public CheckBoxTree(Hashtable<?, ?> hashtable) {
        super(hashtable);
        this.init();
    }

    public CheckBoxTree(TreeNode treeNode) {
        super(treeNode);
        this.init();
    }

    public CheckBoxTree(TreeNode treeNode, boolean bl2) {
        super(treeNode, bl2);
        this.init();
    }

    public CheckBoxTree(TreeModel treeModel) {
        super(treeModel);
        this.init();
    }

    protected void init() {
        this._checkBoxTreeSelectionModel = this.createCheckBoxTreeSelectionModel(this.getModel());
        this._checkBoxTreeSelectionModel.setTree(this);
        Handler handler = this.createHandler();
        JideSwingUtilities.insertMouseListener(this, handler, 0);
        this.addKeyListener(handler);
        this._checkBoxTreeSelectionModel.addTreeSelectionListener(handler);
        if (this._modelChangeListener == null) {
            this._modelChangeListener = new ModelPropertyChangeListener();
        }
        this.addPropertyChangeListener("selectionModel", this._modelChangeListener);
        this.addPropertyChangeListener("model", this._modelChangeListener);
        this.updateRowMapper();
    }

    protected CheckBoxTreeSelectionModel createCheckBoxTreeSelectionModel(TreeModel treeModel) {
        return new CheckBoxTreeSelectionModel(treeModel);
    }

    private void updateRowMapper() {
        this._checkBoxTreeSelectionModel.setRowMapper(this.getSelectionModel().getRowMapper());
    }

    @Override
    public TreeCellRenderer getCellRenderer() {
        TreeCellRenderer treeCellRenderer = this.getActualCellRenderer();
        if (treeCellRenderer == null) {
            treeCellRenderer = this.getDefaultRenderer();
        }
        if (this._treeCellRenderer == null) {
            this._treeCellRenderer = this.createCellRenderer(treeCellRenderer);
        } else {
            this._treeCellRenderer.setActualTreeRenderer(treeCellRenderer);
        }
        return this._treeCellRenderer;
    }

    private TreeCellRenderer getDefaultRenderer() {
        if (this._defaultRenderer == null) {
            this._defaultRenderer = new DefaultTreeCellRenderer();
        }
        return this._defaultRenderer;
    }

    public TreeCellRenderer getActualCellRenderer() {
        if (this._treeCellRenderer != null) {
            return this._treeCellRenderer.getActualTreeRenderer();
        }
        return super.getCellRenderer();
    }

    @Override
    public void setCellRenderer(TreeCellRenderer treeCellRenderer) {
        if (treeCellRenderer == null) {
            treeCellRenderer = this.getDefaultRenderer();
        }
        super.setCellRenderer(treeCellRenderer);
        if (this._treeCellRenderer != null) {
            this._treeCellRenderer.setActualTreeRenderer(treeCellRenderer);
        }
    }

    protected CheckBoxTreeCellRenderer createCellRenderer(TreeCellRenderer treeCellRenderer) {
        CheckBoxTreeCellRenderer checkBoxTreeCellRenderer = new CheckBoxTreeCellRenderer(treeCellRenderer, this.getCheckBox());
        this.addPropertyChangeListener("cellRenderer", new CellRendererPropertyChangeListener(checkBoxTreeCellRenderer));
        return checkBoxTreeCellRenderer;
    }

    protected Handler createHandler() {
        return new Handler(this);
    }

    public TristateCheckBox getCheckBox() {
        return this._checkBox;
    }

    public void setCheckBox(TristateCheckBox tristateCheckBox) {
        if (this._checkBox != tristateCheckBox) {
            this._checkBox = tristateCheckBox;
            this._treeCellRenderer = null;
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isSelectPartialOnToggling() {
        return this._selectPartialOnToggling || this.selectionModel.getClass().getName().contains("Filter");
    }

    public void setSelectPartialOnToggling(boolean bl2) {
        this._selectPartialOnToggling = bl2;
    }

    @Override
    public TreePath getNextMatch(String string, int n2, Position.Bias bias) {
        return null;
    }

    public CheckBoxTreeSelectionModel getCheckBoxTreeSelectionModel() {
        return this._checkBoxTreeSelectionModel;
    }

    public boolean isCheckBoxEnabled() {
        return this._checkBoxEnabled;
    }

    public void setCheckBoxEnabled(boolean bl2) {
        if (bl2 != this._checkBoxEnabled) {
            Boolean bl3 = this._checkBoxEnabled ? Boolean.TRUE : Boolean.FALSE;
            Boolean bl4 = bl2 ? Boolean.TRUE : Boolean.FALSE;
            this._checkBoxEnabled = bl2;
            this.firePropertyChange(PROPERTY_CHECKBOX_ENABLED, bl3, bl4);
            this.repaint();
        }
    }

    public boolean isCheckBoxEnabled(TreePath treePath) {
        return true;
    }

    public boolean isCheckBoxVisible(TreePath treePath) {
        return true;
    }

    public boolean isDigIn() {
        return this.getCheckBoxTreeSelectionModel().isDigIn();
    }

    public void setDigIn(boolean bl2) {
        boolean bl3 = this.isDigIn();
        if (bl3 != bl2) {
            this.getCheckBoxTreeSelectionModel().setDigIn(bl2);
            this.firePropertyChange(PROPERTY_DIG_IN, bl3, bl2);
        }
    }

    public boolean isClickInCheckBoxOnly() {
        return this._clickInCheckBoxOnly;
    }

    public void setClickInCheckBoxOnly(boolean bl2) {
        if (bl2 != this._clickInCheckBoxOnly) {
            boolean bl3 = this._clickInCheckBoxOnly;
            this._clickInCheckBoxOnly = bl2;
            this.firePropertyChange(PROPERTY_CLICK_IN_CHECKBOX_ONLY, bl3, this._clickInCheckBoxOnly);
        }
    }

    protected static class Handler
    implements MouseListener,
    KeyListener,
    TreeSelectionListener {
        protected CheckBoxTree _tree;
        int _hotspot;
        private int _toggleCount;

        public Handler(CheckBoxTree checkBoxTree) {
            this._hotspot = new JCheckBox().getPreferredSize().width;
            this._toggleCount = -1;
            this._tree = checkBoxTree;
        }

        protected TreePath getTreePathForMouseEvent(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return null;
            }
            if (!this._tree.isCheckBoxEnabled()) {
                return null;
            }
            TreePath treePath = this._tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return null;
            }
            if (this.clicksInCheckBox(mouseEvent, treePath) || !this._tree.isClickInCheckBoxOnly()) {
                return treePath;
            }
            return null;
        }

        protected boolean clicksInCheckBox(MouseEvent mouseEvent, TreePath treePath) {
            if (!this._tree.isCheckBoxVisible(treePath)) {
                return false;
            }
            Rectangle rectangle = this._tree.getPathBounds(treePath);
            if (this._tree.getComponentOrientation().isLeftToRight()) {
                return mouseEvent.getX() < rectangle.x + this._hotspot;
            }
            return mouseEvent.getX() > rectangle.x + rectangle.width - this._hotspot;
        }

        private TreePath preventToggleEvent(MouseEvent mouseEvent) {
            int n2;
            TreePath treePath = this.getTreePathForMouseEvent(mouseEvent);
            if (treePath != null && (n2 = this._tree.getToggleClickCount()) != -1) {
                this._toggleCount = n2;
                this._tree.setToggleClickCount(-1);
            }
            return treePath;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            this.preventToggleEvent(mouseEvent);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            TreePath treePath = this.preventToggleEvent(mouseEvent);
            if (treePath != null) {
                JTree jTree;
                this.toggleSelections(new TreePath[]{treePath});
                Object object = mouseEvent.getSource();
                if (object instanceof JTree && !(jTree = (JTree)object).hasFocus() && jTree.isFocusable() && jTree.isRequestFocusEnabled()) {
                    jTree.requestFocusInWindow();
                }
                mouseEvent.consume();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            TreePath treePath = this.preventToggleEvent(mouseEvent);
            if (treePath != null) {
                mouseEvent.consume();
            }
            if (this._toggleCount != -1) {
                this._tree.setToggleClickCount(this._toggleCount);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.isConsumed()) {
                return;
            }
            if (!this._tree.isCheckBoxEnabled()) {
                return;
            }
            if (keyEvent.getModifiers() == 0 && keyEvent.getKeyChar() == ' ') {
                this.toggleSelections();
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            this._tree.treeDidChange();
        }

        protected void toggleSelections() {
            TreePath[] treePathArray = this._tree.getSelectionPaths();
            this.toggleSelections(treePathArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void toggleSelections(TreePath[] treePathArray) {
            if (treePathArray == null || treePathArray.length == 0 || !this._tree.isEnabled()) {
                return;
            }
            CheckBoxTreeSelectionModel checkBoxTreeSelectionModel = this._tree.getCheckBoxTreeSelectionModel();
            ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
            ArrayList<TreePath> arrayList2 = new ArrayList<TreePath>();
            for (TreePath treePath : treePathArray) {
                if (!this._tree.isCheckBoxEnabled(treePath)) continue;
                boolean bl2 = checkBoxTreeSelectionModel.isPathSelected(treePath, checkBoxTreeSelectionModel.isDigIn());
                if (bl2) {
                    arrayList2.add(treePath);
                    continue;
                }
                if (!this._tree.isSelectPartialOnToggling() && checkBoxTreeSelectionModel.isPartiallySelected(treePath)) {
                    TreePath[] treePathArray2 = checkBoxTreeSelectionModel.getSelectionPaths();
                    if (treePathArray2 == null) continue;
                    for (TreePath treePath2 : treePathArray2) {
                        if (!checkBoxTreeSelectionModel.isDescendant(treePath2, treePath)) continue;
                        arrayList2.add(treePath2);
                    }
                    continue;
                }
                arrayList.add(treePath);
            }
            checkBoxTreeSelectionModel.removeTreeSelectionListener(this);
            try {
                if (arrayList.size() > 0) {
                    checkBoxTreeSelectionModel.addSelectionPaths(arrayList.toArray(new TreePath[arrayList.size()]));
                }
                if (arrayList2.size() > 0) {
                    checkBoxTreeSelectionModel.removeSelectionPaths(arrayList2.toArray(new TreePath[arrayList2.size()]));
                }
            }
            finally {
                checkBoxTreeSelectionModel.addTreeSelectionListener(this);
                this._tree.treeDidChange();
            }
        }
    }

    private class ModelPropertyChangeListener
    implements PropertyChangeListener,
    Serializable {
        private static final long serialVersionUID = 521336220746879977L;

        private ModelPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("selectionModel".equals(propertyChangeEvent.getPropertyName())) {
                CheckBoxTree.this.updateRowMapper();
            }
            if ("model".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getNewValue() instanceof TreeModel) {
                CheckBoxTree.this._checkBoxTreeSelectionModel.setModel((TreeModel)propertyChangeEvent.getNewValue());
            }
        }
    }

    private class CellRendererPropertyChangeListener
    implements PropertyChangeListener,
    Serializable {
        private static final long serialVersionUID = -5127656346976320157L;
        private CheckBoxTreeCellRenderer _checkBoxTreeCellRenderer;

        public CellRendererPropertyChangeListener(CheckBoxTreeCellRenderer checkBoxTreeCellRenderer) {
            this._checkBoxTreeCellRenderer = checkBoxTreeCellRenderer;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            TreeCellRenderer treeCellRenderer = (TreeCellRenderer)propertyChangeEvent.getNewValue();
            if (treeCellRenderer != this._checkBoxTreeCellRenderer) {
                this._checkBoxTreeCellRenderer.setActualTreeRenderer(treeCellRenderer);
            } else {
                this._checkBoxTreeCellRenderer.setActualTreeRenderer(null);
            }
        }
    }
}

