/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.extensions.shadow.com.jayway.jsonpath.spi.cache;

import com.install4j.extensions.shadow.com.jayway.jsonpath.JsonPathException;
import com.install4j.extensions.shadow.com.jayway.jsonpath.internal.Utils;
import com.install4j.extensions.shadow.com.jayway.jsonpath.spi.cache.Cache;
import com.install4j.extensions.shadow.com.jayway.jsonpath.spi.cache.LRUCache;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class CacheProvider {
    private static final AtomicReferenceFieldUpdater<CacheProvider, Cache> UPDATER = AtomicReferenceFieldUpdater.newUpdater(CacheProvider.class, Cache.class, "cache");
    private static final CacheProvider instance = new CacheProvider();
    private volatile Cache cache;

    public static void setCache(Cache cache) {
        Utils.notNull(cache, "Cache may not be null");
        if (!UPDATER.compareAndSet(instance, null, cache)) {
            throw new JsonPathException("Cache provider must be configured before cache is accessed and must not be registered twice.");
        }
    }

    public static Cache getCache() {
        return CacheHolder.CACHE;
    }

    private static Cache getDefaultCache() {
        return new LRUCache(400);
    }

    private static class CacheHolder {
        static final Cache CACHE;

        private CacheHolder() {
        }

        static {
            Cache cache = instance.cache;
            if (cache == null) {
                cache = CacheProvider.getDefaultCache();
                if (!UPDATER.compareAndSet(instance, null, cache)) {
                    cache = instance.cache;
                }
            }
            CACHE = cache;
        }
    }
}

