/*
 * Decompiled with CFR 0.152.
 */
package com.install4j;

import com.install4j.BaseTask;
import com.install4j.buildtools.CreateBundleTaskConfig;
import com.install4j.buildtools.ModuleSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.jetbrains.annotations.NotNull;

public class CreateBundleTask
extends BaseTask {
    private File javaHome;
    private File outputDirectory;
    private String version;
    private boolean unpacked;
    private String id;
    private String jdkRelease;
    private String jdkProviderId;
    private String addModules;
    private ModuleSet addModuleSet;
    private File addJmod;
    private File addJmodDir;
    private List<Jmod> jmods = new ArrayList<Jmod>();
    private Provider provider;

    public CreateBundleTask() {
        this(null);
    }

    public CreateBundleTask(Provider provider) {
        this.provider = provider;
    }

    public void setJavaHome(File javaHome) {
        this.javaHome = javaHome;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setUnpacked(boolean unpacked) {
        this.unpacked = unpacked;
    }

    public void setJdkRelease(String jdkRelease) {
        this.jdkRelease = jdkRelease;
    }

    public void setJdkProviderId(String jdkProviderId) {
        this.jdkProviderId = jdkProviderId;
    }

    public void setAddModules(String addModules) {
        this.addModules = addModules;
    }

    public void setAddModuleSet(String addModuleSet) {
        this.addModuleSet = ModuleSet.getFromOptionValue(addModuleSet);
        if (this.addModuleSet == null && addModuleSet != null) {
            throw new BuildException("The value \"" + addModuleSet + "\" for addModuleSet is not supported.");
        }
    }

    @Deprecated
    public void setAddJmod(File addJmod) {
        this.addJmod = addJmod;
    }

    @Deprecated
    public void setAddJmodDir(File addJmodDir) {
        this.addJmodDir = addJmodDir;
    }

    public void addConfiguredJmod(Jmod jmod) {
        jmod.check();
        this.jmods.add(jmod);
    }

    @Override
    protected String getApplicationName() {
        return "install4j";
    }

    public void execute() throws BuildException {
        this.runExecutable(this.createTaskConfig());
    }

    @NotNull
    private CreateBundleTaskConfig createTaskConfig() {
        if (this.provider != null) {
            return this.provider.createTaskConfig();
        }
        return new CreateBundleTaskConfig(this.getInstallDir(), this.getAutoProvisioningCacheDir(), this.getVmParameters(), this.javaHome, this.outputDirectory, this.version, this.unpacked, this.id, this.jdkRelease, this.jdkProviderId, this.getAddModules(), this.addModuleSet, this.getJmodFiles(), this.getJmodDirs());
    }

    private List<String> getAddModules() {
        if (this.addModules == null) {
            return null;
        }
        return Arrays.asList(this.addModules.split(","));
    }

    private List<File> getJmodFiles() {
        ArrayList<File> files = new ArrayList<File>();
        if (this.addJmod != null) {
            files.add(this.addJmod);
        }
        for (Jmod jmod : this.jmods) {
            if (jmod.file == null) continue;
            files.add(jmod.file);
        }
        return files;
    }

    private List<File> getJmodDirs() {
        ArrayList<File> files = new ArrayList<File>();
        if (this.addJmodDir != null) {
            files.add(this.addJmodDir);
        }
        for (Jmod jmod : this.jmods) {
            if (jmod.dir == null) continue;
            files.add(jmod.dir);
        }
        return files;
    }

    public static interface Provider {
        public CreateBundleTaskConfig createTaskConfig();
    }

    public static class Jmod {
        private File file;
        private File dir;

        public void setFile(File file) {
            this.file = file;
        }

        public void setDir(File dir) {
            this.dir = dir;
        }

        private void check() throws BuildException {
            if (this.file == null && this.dir == null) {
                throw new BuildException("Either the \"file\" or the \"dir\" property has to be set for jmod elements.");
            }
            if (this.file != null && this.dir != null) {
                throw new BuildException("Cannot set both \"file\" and \"dir\" properties for jmod elements at the same time.");
            }
        }
    }
}

