/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.customizers.programgroup;

import com.ejt.internal.gui.fl;
import com.ejt.internal.gui.w.i;
import com.install4j.c.d.b.d.p;
import com.install4j.runtime.beans.customizers.programgroup.ProgramGroupDefinitionTree;
import com.install4j.runtime.beans.customizers.programgroup.ProgramGroupEntryDialog;
import com.install4j.runtime.beans.screens.components.ProgramGroupUrlConfig;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;

public class ProgramGroupUrlDialog
extends ProgramGroupEntryDialog<ProgramGroupUrlConfig> {
    public static final String URL_TEXT_FIELD_NAME = "urlTextField";
    public static final String FAVICON_CHECKBOX_NAME = "faviconCheckbox";
    private JTextField txtUrl;
    private JCheckBox chkFavicon;

    public ProgramGroupUrlDialog(ProgramGroupDefinitionTree programGroupDefinitionTree) {
        super(programGroupDefinitionTree);
    }

    @Override
    protected String getTitleText() {
        return "Edit Start Menu URL Link";
    }

    @Override
    protected void setupControls() {
        super.setupControls();
        this.txtUrl = new i();
        this.txtUrl.setName(URL_TEXT_FIELD_NAME);
        this.chkFavicon = new JCheckBox("Use favicon from the above URL");
        this.chkFavicon.setName(FAVICON_CHECKBOX_NAME);
    }

    @Override
    protected JComponent createCenterPanel() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("insets 0, wrap", "[][fill, grow]", "[][][]para[][][]unrel"));
        jPanel.add((Component)new fl("Mandatory settings"), "spanx, growx");
        jPanel.add(new JLabel("Display name:"));
        jPanel.add(this.wrapTextField(this.getNameTextField()));
        jPanel.add(new JLabel("Target URL:"));
        jPanel.add(this.wrapTextField(this.txtUrl));
        jPanel.add((Component)new fl("Optional settings"), "spanx, growx");
        jPanel.add(new JLabel("Display icon:"));
        jPanel.add(this.createFileChooserButton(this.getIconTextField(), new ProgramGroupEntryDialog.IconFileChooserProvider()));
        jPanel.add((Component)this.chkFavicon, "spanx");
        return jPanel;
    }

    @Override
    public void setConfig(ProgramGroupUrlConfig programGroupUrlConfig, p p2) {
        super.setConfig(programGroupUrlConfig, p2);
        this.txtUrl.setText(programGroupUrlConfig.getUrl());
        this.chkFavicon.setSelected(programGroupUrlConfig.isFavicon());
    }

    @Override
    protected boolean validateInput() {
        return super.validateInput() && !this.checkEmpty(this.txtUrl, "target URL");
    }

    @Override
    protected void saveConfig(ProgramGroupUrlConfig programGroupUrlConfig) {
        super.saveConfig(programGroupUrlConfig);
        this.checkModified(this.txtUrl, programGroupUrlConfig.getUrl());
        this.checkModified(this.chkFavicon, programGroupUrlConfig.isFavicon());
        programGroupUrlConfig.setUrl(this.txtUrl.getText().trim());
        programGroupUrlConfig.setFavicon(this.chkFavicon.isSelected());
    }
}

