/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.desktop;

import com.install4j.api.beaninfo.ActionElevationType;
import com.install4j.api.beaninfo.BeanValidationException;
import com.install4j.api.beaninfo.BeanValidator;
import com.install4j.api.beaninfo.FilePropertyDescriptor;
import com.install4j.api.beaninfo.FileSelectionMode;
import com.install4j.api.beaninfo.Install4JPropertyDescriptor;
import com.install4j.api.beans.Bean;
import com.install4j.runtime.beans.BeanInfo;
import com.install4j.runtime.beans.actions.SystemActionBeanInfo;
import com.install4j.runtime.beans.actions.desktop.AddStartupItemAction;
import com.install4j.runtime.beans.common.BeanInfoUtil;
import com.install4j.runtime.beans.common.CategoryUtil;

@BeanInfo
public class AddStartupItemActionBeanInfo
extends SystemActionBeanInfo
implements BeanValidator {
    public static final String NAME = "Add a startup executable";
    private static final String PROPERTY_EXECUTABLE = "executable";
    private static final String PROPERTY_NAME = "name";
    private static final String PROPERTY_ALL_USERS = "allUsers";
    private static final String PROPERTY_HIDE = "hide";

    public AddStartupItemActionBeanInfo() {
        super(NAME, "Add an installed executable to the startup folder on Windows, as a launch agent on macOS or as a systemd user service on Linux so that it will be started automatically when the user logs in. This action will be automatically reverted by the 'Uninstall files' action.", "Desktop integration", true, true, null, AddStartupItemAction.class);
        this.setDefaultActionElevationType(ActionElevationType.ELEVATE, true);
        this.addPropertyDescriptor((Install4JPropertyDescriptor)FilePropertyDescriptor.create((String)PROPERTY_EXECUTABLE, (Class)this.getBeanClass(), (String)"Startup executable", (String)"The executable that should be started when the user logs in", (FileSelectionMode)FileSelectionMode.FILES_AND_DIRECTORIES));
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)"arguments", (Class)this.getBeanClass(), (String)"Arguments", (String)("The arguments passed to the executable." + BeanInfoUtil.ARGUMENTS_NOTICE)));
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)"startImmediately", (Class)this.getBeanClass(), (String)"Start immediately", (String)"If the executable should be started immediately by the action"));
        this.addPropertyDescriptor(CategoryUtil.categoryWindows(Install4JPropertyDescriptor.create((String)PROPERTY_NAME, (Class)this.getBeanClass(), (String)"Entry name", (String)"The name of the entry in the startup folder")));
        this.addPropertyDescriptor(CategoryUtil.categoryWindows(Install4JPropertyDescriptor.create((String)PROPERTY_ALL_USERS, (Class)this.getBeanClass(), (String)"Create for all users", (String)"If the startup item should be created for all users. If unselected, the link will be created for the current user only.")));
        this.addPropertyDescriptor(CategoryUtil.categoryMacos(Install4JPropertyDescriptor.create((String)PROPERTY_HIDE, (Class)this.getBeanClass(), (String)"Set the hide flag", (String)"If the hide flag should be set for the login item.")));
        this.addPropertyDescriptor(CategoryUtil.categoryMacos(Install4JPropertyDescriptor.create((String)"macosIdentifier", (Class)this.getBeanClass(), (String)"macOS identifier", (String)"The optional identifier for the launch agent. If not specified, an identifier will be generated automatically.")));
        this.addPropertyDescriptor(CategoryUtil.categoryUnix(Install4JPropertyDescriptor.create((String)"requireGraphicalSession", (Class)this.getBeanClass(), (String)"Require graphical session", (String)"If the systemd user service should require a graphical session.")));
    }

    public void validateBean(Bean bean) throws BeanValidationException {
        this.checkNotEmpty(PROPERTY_EXECUTABLE, bean);
        this.checkNotEmpty(PROPERTY_NAME, bean);
    }
}

