/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicTextAreaUI;

public class DisplayTextArea
extends JTextArea {
    private static final Insets NO_MARGIN = new Insets(0, 0, 0, 0);
    private Border border;
    private int maxWidth;

    public DisplayTextArea() {
        this(true, -1, -1);
    }

    public DisplayTextArea(boolean lineWrap, int fontStyle, int maxWidth) {
        this.maxWidth = maxWidth;
        this.setLineWrap(lineWrap);
        this.setWrapStyleWord(lineWrap);
        this.setEditable(false);
        this.setRequestFocusEnabled(false);
        this.setFocusable(false);
        this.setMargin(NO_MARGIN);
        this.updateUI();
        JLabel label = new JLabel();
        Font font = label.getFont();
        if (fontStyle != -1) {
            font = font.deriveFont(fontStyle);
        }
        this.setFont(font);
        this.setBorder(this.border);
        this.setOpaque(false);
    }

    @Override
    public final void processEvent(AWTEvent awtevent) {
        if (this.isFocusable()) {
            super.processEvent(awtevent);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.maxWidth > -1) {
            dimension.width = Math.min(dimension.width, this.maxWidth);
        }
        return dimension;
    }

    @Override
    public void setBorder(Border border) {
        this.border = border;
        super.setBorder(border);
    }

    @Override
    public void updateUI() {
        this.setUI(new BasicTextAreaUI());
        this.invalidate();
    }

    @Override
    public void scrollRectToVisible(Rectangle aRect) {
    }
}

