/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.apiimpl;

import com.install4j.api.Util;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.launching.LaunchDescriptor;
import com.install4j.runtime.installer.helper.launching.LaunchHelper;
import com.install4j.runtime.installer.platform.macos.PlistHelper;
import com.install4j.runtime.installer.platform.unix.Execution;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class ServiceInfoImpl {
    public static boolean isServiceRunning(File serviceFile) {
        if (!serviceFile.exists()) {
            return false;
        }
        if (Util.isMacOS()) {
            String status = ServiceInfoImpl.printMacosStatus(serviceFile);
            if (status != null) {
                return (status = status.toLowerCase(Locale.ROOT)).contains("pid =") || status.contains("pid=");
            }
            return false;
        }
        StringBuffer output = new StringBuffer();
        try {
            int returnCode = Execution.executeWithReturnCode(new String[]{serviceFile.getAbsolutePath(), (Util.isWindows() ? "/" : "") + "status"}, output, false);
            return returnCode == 0;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isServiceInstalled(File serviceFile) {
        if (!serviceFile.exists()) {
            return false;
        }
        if (Util.isMacOS()) {
            return ServiceInfoImpl.printMacosStatus(serviceFile) != null;
        }
        if (Util.isWindows()) {
            StringBuffer output = new StringBuffer();
            try {
                int returnCode = Execution.executeWithReturnCode(new String[]{serviceFile.getAbsolutePath(), "/status"}, output, false);
                return returnCode == 0 || returnCode == 3;
            }
            catch (IOException e) {
                return false;
            }
        }
        File systemctlFile = new File("/usr/bin/systemctl");
        if (systemctlFile.isFile()) {
            Integer returnValue = LaunchHelper.launchApplication(new LaunchDescriptor(systemctlFile).arguments("--no-ask-password", "status", serviceFile.getName()).wait(true).executionContext(ExecutionContext.MAXIMUM).logReturnValue(false));
            return returnValue != null && returnValue >= 0 && returnValue <= 3;
        }
        return false;
    }

    private static String printMacosStatus(File serviceFile) {
        String identifier = ServiceInfoImpl.findMacosIdentifier(serviceFile);
        if (identifier != null) {
            Execution.Result result = Execution.executeAndWaitWithResult("/bin/launchctl", "print", identifier);
            if (result.returnCode == 0) {
                return result.output;
            }
        }
        return null;
    }

    private static String findMacosIdentifier(File serviceFile) {
        try {
            File bundleDaemonsDir;
            String path = serviceFile.getCanonicalPath();
            String identifier = ServiceInfoImpl.getIdentifierFromDaemonsDir(path, new File("/Library/LaunchDaemons"));
            if (identifier != null) {
                return identifier;
            }
            int appBundleStart = path.indexOf(".app/Contents/Resources/app/");
            if (appBundleStart > -1 && (bundleDaemonsDir = new File(path.substring(0, appBundleStart) + ".app/Contents/Library/LaunchDaemons")).isDirectory() && (identifier = ServiceInfoImpl.getIdentifierFromDaemonsDir(path.substring(appBundleStart + 5), bundleDaemonsDir)) != null) {
                return identifier;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    private static String getIdentifierFromDaemonsDir(String executablePath, File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isFile() || file.getName().startsWith(".") || !file.getName().endsWith(".plist") || file.length() >= 50000L) continue;
                try {
                    String fileContent = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
                    if (fileContent.contains("<string>" + PlistHelper.quoteCharacters(executablePath) + "</string>")) {
                        return "system/" + file.getName().substring(0, file.getName().length() - 6);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }
}

