/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.ejt.internal.gui.CommonColorUtil;
import com.ejt.internal.gui.LookAndFeelChangeUtil;
import com.install4j.api.formcomponents.WidgetStyleHandler;
import com.install4j.runtime.beans.formcomponents.FontDescriptor;
import com.install4j.runtime.beans.formcomponents.FormEnvironmentImpl;
import com.install4j.runtime.beans.widgets.AbstractLabelWidgetStyle;
import com.install4j.runtime.beans.widgets.AbstractWidgetStyle;
import com.install4j.runtime.beans.widgets.ButtonWidgetStyle;
import com.install4j.runtime.beans.widgets.ComboBoxWidgetStyle;
import com.install4j.runtime.beans.widgets.HyperlinkWidgetStyle;
import com.install4j.runtime.beans.widgets.LabelWidgetStyle;
import com.install4j.runtime.beans.widgets.ListWidgetStyle;
import com.install4j.runtime.beans.widgets.ProgressBarWidgetStyle;
import com.install4j.runtime.beans.widgets.SliderWidgetStyle;
import com.install4j.runtime.beans.widgets.TextComponentWidgetStyle;
import com.install4j.runtime.beans.widgets.ToggleButtonWidgetStyle;
import com.install4j.runtime.beans.widgets.WidgetStyleCollection;
import com.install4j.runtime.beans.widgets.WindowWidgetStyle;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.WidgetStyleBeanConfig;
import com.install4j.runtime.util.HtmlDisplayTextArea;
import com.install4j.runtime.util.HyperlinkLabel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.function.Function;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Nullable;

public class WidgetStyleHandlerImpl
implements WidgetStyleHandler {
    public static final String PROPERTY_FLAT_LAF_STYLE = "FlatLaf.style";
    private static WidgetStyleHandlerImpl defaultInstance;
    @Nullable
    private FormEnvironmentImpl formEnvironment;

    public static WidgetStyleHandlerImpl getDefaultInstance() {
        if (defaultInstance == null) {
            defaultInstance = new WidgetStyleHandlerImpl(null);
        }
        return defaultInstance;
    }

    public WidgetStyleHandlerImpl(@Nullable FormEnvironmentImpl formEnvironment) {
        this.formEnvironment = formEnvironment;
    }

    @Override
    public <T extends JButton> T applyWidgetStyle(T button, String widgetStyleId) {
        return this.applyWidgetStyle(button, "", null);
    }

    public <T extends JButton> T applyWidgetStyle(T button, String widgetStyleId, ButtonWidgetStyle buttonWidgetStyle) {
        ButtonWidgetStyle widgetStyle = this.getResolvedWidgetStyle(widgetStyleId, buttonWidgetStyle, WidgetStyleCollection::getButtonWidgetStyle);
        if (widgetStyle != null) {
            this.applyFont(button, widgetStyle.getFontDescriptor());
            this.applyInsets(button, widgetStyle.getInsets());
            button.putClientProperty("JButton.buttonType", widgetStyle.getButtonType().getTypeName());
            this.applyStyle(button, style -> {
                this.addStyleColor("background", widgetStyle.getBackgroundColor(), style);
                this.addStyleColor("foreground", widgetStyle.getForegroundColor(), style);
                this.addStyleColor("disabledBackground", widgetStyle.getDisabledBackgroundColor(), style);
                this.addStyleColor("disabledText", widgetStyle.getDisabledForegroundColor(), style);
                this.addStyleColor("hoverBackground", widgetStyle.getHoverBackgroundColor(), style);
                this.addStyleColor("hoverForeground", widgetStyle.getHoverForegroundColor(), style);
                this.addStyleColor("focusedBackground", widgetStyle.getFocusedBackgroundColor(), style);
                this.addStyleColor("focusedForeground", widgetStyle.getFocusedForegroundColor(), style);
                this.addStyleColor("pressedBackground", widgetStyle.getPressedBackgroundColor(), style);
                this.addStyleColor("pressedForeground", widgetStyle.getPressedForegroundColor(), style);
            });
        }
        return button;
    }

    @Override
    public <T extends JTextComponent> T applyWidgetStyle(T textComponent, String widgetStyleId) {
        return this.applyWidgetStyle(textComponent, widgetStyleId, (TextComponentWidgetStyle)null);
    }

    public <T extends JTextComponent> T applyWidgetStyle(T textComponent, String widgetStyleId, TextComponentWidgetStyle textComponentWidgetStyle) {
        TextComponentWidgetStyle widgetStyle = this.getResolvedWidgetStyle(widgetStyleId, textComponentWidgetStyle, WidgetStyleCollection::getTextComponentWidgetStyle);
        if (widgetStyle != null) {
            this.applyFont(textComponent, widgetStyle.getFontDescriptor());
            this.applyInsets(textComponent, widgetStyle.getInsets());
            textComponent.setDisabledTextColor(widgetStyle.getDisabledForegroundColor());
            this.applyStyle(textComponent, style -> {
                this.addStyleColor("background", widgetStyle.getBackgroundColor(), style);
                this.addStyleColor("foreground", widgetStyle.getForegroundColor(), style);
                this.addStyleColor("disabledBackground", widgetStyle.getDisabledBackgroundColor(), style);
                this.addStyleColor("inactiveBackground", widgetStyle.getNonEditableBackgroundColor(), style);
                this.addStyleColor("focusedBackground", widgetStyle.getFocusedBackgroundColor(), style);
            });
        }
        return textComponent;
    }

    @Override
    public <T extends JSpinner> T applyWidgetStyle(T textField, String widgetStyleId) {
        return this.applyWidgetStyle(textField, widgetStyleId, null);
    }

    public <T extends JSpinner> T applyWidgetStyle(T spinner, String widgetStyleId, TextComponentWidgetStyle textComponentWidgetStyle) {
        TextComponentWidgetStyle widgetStyle = this.getResolvedWidgetStyle(widgetStyleId, textComponentWidgetStyle, WidgetStyleCollection::getTextComponentWidgetStyle);
        if (widgetStyle != null) {
            this.applyFont(spinner, widgetStyle.getFontDescriptor());
            this.applyStyle(spinner, style -> {
                this.addStyleColor("background", widgetStyle.getBackgroundColor(), style);
                this.addStyleColor("foreground", widgetStyle.getForegroundColor(), style);
                this.addStyleColor("disabledBackground", widgetStyle.getDisabledBackgroundColor(), style);
                this.addStyleColor("disabledForeground", widgetStyle.getDisabledForegroundColor(), style);
                this.addStyleColor("focusedBackground", widgetStyle.getFocusedBackgroundColor(), style);
                this.addStyleInsets("padding", widgetStyle.getInsets(), style);
            });
        }
        return spinner;
    }

    @Override
    public <T extends JComboBox> T applyWidgetStyle(T comboBox, String widgetStyleId) {
        return this.applyWidgetStyle(comboBox, widgetStyleId, null);
    }

    public <T extends JComboBox> T applyWidgetStyle(T comboBox, String widgetStyleId, ComboBoxWidgetStyle comboBoxWidgetStyle) {
        ComboBoxWidgetStyle widgetStyle = this.getResolvedWidgetStyle(widgetStyleId, comboBoxWidgetStyle, WidgetStyleCollection::getComboBoxWidgetStyle);
        if (widgetStyle != null) {
            this.applyFont(comboBox, widgetStyle.getFontDescriptor());
            this.applyStyle(comboBox, style -> {
                this.addStyleColor("background", widgetStyle.getBackgroundColor(), style);
                this.addStyleColor("foreground", widgetStyle.getForegroundColor(), style);
                this.addStyleColor("disabledBackground", widgetStyle.getDisabledBackgroundColor(), style);
                this.addStyleColor("disabledForeground", widgetStyle.getDisabledBackgroundColor(), style);
                this.addStyleColor("focusedBackground", widgetStyle.getFocusedBackgroundColor(), style);
                this.addStyleColor("editableBackground", widgetStyle.getEditableBackgroundColor(), style);
                this.addStyleColor("popupBackground", widgetStyle.getPopupBackgroundColor(), style);
            });
        }
        return comboBox;
    }

    public HyperlinkLabel applyWidgetStyle(HyperlinkLabel hyperlinkLabel, String widgetStyleId, HyperlinkWidgetStyle hyperlinkWidgetStyle) {
        HyperlinkWidgetStyle widgetStyle = this.getResolvedWidgetStyle(widgetStyleId, hyperlinkWidgetStyle, WidgetStyleCollection::getHyperlinkWidgetStyle);
        if (widgetStyle != null) {
            Color pressedColor;
            this.applyFont(hyperlinkLabel, widgetStyle.getFontDescriptor());
            Color color = widgetStyle.getForegroundColor();
            if (color != null) {
                hyperlinkLabel.setPassiveColor(color);
            }
            if ((pressedColor = widgetStyle.getPressedColor()) != null) {
                hyperlinkLabel.setActiveColor(pressedColor);
            }
        }
        return hyperlinkLabel;
    }

    @Override
    public <T extends JLabel> T applyWidgetStyle(T label, String widgetStyleId) {
        return this.applyWidgetStyle(label, widgetStyleId, null);
    }

    public <T extends JLabel> T applyWidgetStyle(T label, String widgetStyleId, LabelWidgetStyle labelWidgetStyle) {
        LabelWidgetStyle widgetStyle = this.getResolvedWidgetStyle(widgetStyleId, labelWidgetStyle, WidgetStyleCollection::getLabelWidgetStyle);
        if (widgetStyle != null) {
            this.applyComponentLabelStyle(label, widgetStyle);
            label.setIconTextGap(widgetStyle.getIconTextGap());
            this.applyStyle(label, style -> this.addStyleColor("disabledForeground", widgetStyle.getDisabledForegroundColor(), style));
        }
        return label;
    }

    public <T extends JComponent> T applyLabelWidgetStyle(T component, String widgetStyleId, LabelWidgetStyle labelWidgetStyle) {
        LabelWidgetStyle widgetStyle = this.getResolvedWidgetStyle(widgetStyleId, labelWidgetStyle, WidgetStyleCollection::getLabelWidgetStyle);
        if (widgetStyle != null) {
            this.applyComponentLabelStyle(component, widgetStyle);
        }
        return component;
    }

    public HtmlDisplayTextArea applyLabelWidgetStyle(HtmlDisplayTextArea htmlDisplayTextArea, String widgetStyleId, LabelWidgetStyle labelWidgetStyle) {
        LabelWidgetStyle widgetStyle = this.getResolvedWidgetStyle(widgetStyleId, labelWidgetStyle, WidgetStyleCollection::getLabelWidgetStyle);
        if (widgetStyle != null) {
            htmlDisplayTextArea.setOverrideForeground(widgetStyle.getForegroundColor());
            htmlDisplayTextArea.setOverrideFont(widgetStyle.getFontDescriptor().getFont(htmlDisplayTextArea));
        }
        return htmlDisplayTextArea;
    }

    @Override
    public <T extends JToggleButton> T applyWidgetStyle(T toggleButton, String widgetStyleId) {
        return this.applyWidgetStyle(toggleButton, widgetStyleId, null);
    }

    public <T extends JToggleButton> T applyWidgetStyle(T toggleButton, String widgetStyleId, ToggleButtonWidgetStyle toggleButtonWidgetStyle) {
        ToggleButtonWidgetStyle widgetStyle = this.getResolvedWidgetStyle(widgetStyleId, toggleButtonWidgetStyle, WidgetStyleCollection::getToggleButtonWidgetStyle);
        if (widgetStyle != null) {
            this.applyComponentLabelStyle(toggleButton, widgetStyle);
            this.applyStyle(toggleButton, style -> this.addStyleColor("disabledText", widgetStyle.getDisabledForegroundColor(), style));
        }
        return toggleButton;
    }

    @Override
    public <T extends JList> T applyWidgetStyle(T list, String widgetStyleId) {
        return this.applyWidgetStyle(list, widgetStyleId, (ListWidgetStyle)null);
    }

    public <T extends JList> T applyWidgetStyle(T list, String widgetStyleId, ListWidgetStyle listWidgetStyle) {
        return this.applyListWidgetStyle(list, widgetStyleId, listWidgetStyle);
    }

    @Override
    public <T extends JTree> T applyWidgetStyle(T tree, String widgetStyleId) {
        return this.applyWidgetStyle(tree, widgetStyleId, null);
    }

    public <T extends JTree> T applyWidgetStyle(T tree, String widgetStyleId, ListWidgetStyle listWidgetStyle) {
        return this.applyListWidgetStyle(tree, widgetStyleId, listWidgetStyle);
    }

    private <T extends JComponent> T applyListWidgetStyle(T component, String widgetStyleId, ListWidgetStyle listWidgetStyle) {
        ListWidgetStyle widgetStyle = this.getResolvedWidgetStyle(widgetStyleId, listWidgetStyle, WidgetStyleCollection::getListWidgetStyle);
        if (widgetStyle != null) {
            this.applyComponentLabelStyle(component, widgetStyle);
            Color backgroundColor = widgetStyle.getBackgroundColor();
            if (backgroundColor != null) {
                component.setBackground(backgroundColor);
            }
            this.applyStyle(component, style -> {
                this.addStyleColor("selectionBackground", widgetStyle.getSelectionBackgroundColor(), style);
                this.addStyleColor("selectionForeground", widgetStyle.getSelectionForegroundColor(), style);
                this.addStyleColor("selectionInactiveBackground", widgetStyle.getSelectionInactiveBackgroundColor(), style);
                this.addStyleColor("selectionInactiveForeground", widgetStyle.getSelectionInactiveForegroundColor(), style);
            });
        }
        return component;
    }

    @Override
    public <T extends JSlider> T applyWidgetStyle(T slider, String widgetStyleId) {
        return this.applyWidgetStyle(slider, widgetStyleId, null);
    }

    public <T extends JSlider> T applyWidgetStyle(T slider, String widgetStyleId, SliderWidgetStyle sliderWidgetStyle) {
        SliderWidgetStyle widgetStyle = this.getResolvedWidgetStyle(widgetStyleId, sliderWidgetStyle, WidgetStyleCollection::getSliderWidgetStyle);
        if (widgetStyle != null) {
            this.applyComponentLabelStyle(slider, widgetStyle);
            this.applyStyle(slider, style -> {
                this.addStyleColor("tickColor", widgetStyle.getTickColor(), style);
                this.addStyleColor("trackColor", widgetStyle.getTrackColor(), style);
            });
        }
        return slider;
    }

    @Override
    public <T extends JProgressBar> T applyWidgetStyle(T progressBar, String widgetStyleId) {
        return this.applyWidgetStyle(progressBar, widgetStyleId, null);
    }

    public <T extends JProgressBar> T applyWidgetStyle(T progressBar, String widgetStyleId, ProgressBarWidgetStyle progressBarWidgetStyle) {
        ProgressBarWidgetStyle widgetStyle = this.getResolvedWidgetStyle(widgetStyleId, progressBarWidgetStyle, WidgetStyleCollection::getProgressBarWidgetStyle);
        if (widgetStyle != null) {
            Color color = widgetStyle.getColor();
            if (color != null) {
                progressBar.setForeground(color);
            }
            this.applyStyle(progressBar, style -> this.addStyleDimension("horizontalSize", new Dimension(146, widgetStyle.getHeight()), style));
        }
        return progressBar;
    }

    public void applyWindowStyle(JPanel panel) {
        Color backgroundColor;
        WindowWidgetStyle widgetStyle = this.getResolvedWidgetStyle("", WidgetStyleCollection::getWindowWidgetStyle);
        if (widgetStyle != null && (backgroundColor = widgetStyle.getBackgroundColor()) != null) {
            panel.setBackground(backgroundColor);
        }
    }

    private void applyComponentLabelStyle(JComponent component, AbstractLabelWidgetStyle widgetStyle) {
        this.applyFont(component, widgetStyle.getFontDescriptor());
        Color foregroundColor = widgetStyle.getForegroundColor();
        if (foregroundColor != null) {
            component.setForeground(foregroundColor);
        }
    }

    private void applyInsets(AbstractButton component, Insets insets) {
        if (insets != null) {
            component.setMargin(insets);
        }
    }

    private void applyInsets(JTextComponent component, Insets insets) {
        if (insets != null) {
            component.setMargin(insets);
        }
    }

    private void applyFont(JComponent component, FontDescriptor fontDescriptor) {
        fontDescriptor.applyFont(component);
    }

    private void addStyleColor(String styleKey, Color color, StringBuilder style) {
        if (color != null) {
            style.append(styleKey).append(": ").append(CommonColorUtil.toHex(color)).append(";");
        }
    }

    private void addStyleDimension(String styleKey, Dimension dimension, StringBuilder style) {
        if (dimension != null) {
            style.append(styleKey).append(": ").append(dimension.width).append(",").append(dimension.height).append(";");
        }
    }

    private void addStyleInsets(String styleKey, Insets insets, StringBuilder style) {
        if (insets != null) {
            style.append(styleKey).append(": ");
            style.append(insets.top).append(",");
            style.append(insets.left).append(",");
            style.append(insets.bottom).append(",");
            style.append(insets.right).append(",");
            style.append(";");
        }
    }

    protected <T extends AbstractWidgetStyle> T getResolvedWidgetStyle(String widgetStyleId, T widgetStyle, Function<WidgetStyleCollection, T> widgetStyleGetter) {
        if (widgetStyleId == null) {
            WidgetStyleCollection defaultsWidgetStyleCollection = this.getWidgetStyleCollection("");
            if (defaultsWidgetStyleCollection != null) {
                widgetStyle.applyDefaults(defaultsWidgetStyleCollection.getDefaultsWidgetStyle());
            }
            return widgetStyle;
        }
        return this.getResolvedWidgetStyle(widgetStyleId, widgetStyleGetter);
    }

    @Nullable
    protected <T extends AbstractWidgetStyle> T getResolvedWidgetStyle(String widgetStyleId, Function<WidgetStyleCollection, T> widgetStyleGetter) {
        WidgetStyleCollection widgetStyleCollection = this.getWidgetStyleCollection(widgetStyleId);
        if (widgetStyleCollection != null) {
            AbstractWidgetStyle inheritedWidgetStyle = (AbstractWidgetStyle)widgetStyleGetter.apply(widgetStyleCollection);
            inheritedWidgetStyle.applyDefaults(widgetStyleCollection.getDefaultsWidgetStyle());
            return (T)inheritedWidgetStyle;
        }
        return null;
    }

    private WidgetStyleCollection getWidgetStyleCollection(String widgetStyleId) {
        String resolvedWidgetStyleId = this.resolveDefaultWidgetStyleId(widgetStyleId);
        if (resolvedWidgetStyleId != null) {
            WidgetStyleCollection widgetStyleCollection;
            if (this.formEnvironment != null && (widgetStyleCollection = this.formEnvironment.getWidgetStyleCollectionById(resolvedWidgetStyleId)) != null) {
                return widgetStyleCollection;
            }
            return this.getWidgetStyleCollectionById(resolvedWidgetStyleId);
        }
        return null;
    }

    private WidgetStyleCollection getWidgetStyleCollectionById(String resolvedWidgetStyleId) {
        if (this.formEnvironment != null && this.formEnvironment.isDesignTime()) {
            return null;
        }
        WidgetStyleBeanConfig widgetStyleConfig = InstallerConfig.getCurrentInstance().getWidgetStyleConfigById(resolvedWidgetStyleId);
        if (widgetStyleConfig != null) {
            return widgetStyleConfig.getOrInstantiateStyle(false);
        }
        return null;
    }

    private String resolveDefaultWidgetStyleId(String widgetStyleId) {
        if (widgetStyleId.isEmpty()) {
            if (this.formEnvironment != null) {
                return this.formEnvironment.getFormPanel().getDefaultWidgetStyleId();
            }
            InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
            if (installerConfig != null) {
                return installerConfig.getDefaultWidgetStyleId();
            }
            return null;
        }
        return widgetStyleId;
    }

    private void applyStyle(JComponent component, StyleBuilder styleBuilder) {
        LookAndFeelChangeUtil.onLookAndFeelChangeAndNow(component, parent -> {
            StringBuilder style = new StringBuilder();
            styleBuilder.addStyles(style);
            if (style.length() > 0) {
                Object styleValue = component.getClientProperty(PROPERTY_FLAT_LAF_STYLE);
                component.putClientProperty(PROPERTY_FLAT_LAF_STYLE, (styleValue != null ? styleValue + " " : "") + style);
            }
        });
    }

    private static interface StyleBuilder {
        public void addStyles(StringBuilder var1);
    }
}

