/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import com.install4j.runtime.beans.LightOrDarkColor;
import com.install4j.runtime.util.CustomLabel;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Objects;
import javax.swing.Action;

public class HyperlinkLabel
extends CustomLabel
implements MouseListener {
    public static final Color COLOR_PASSIVE = new LightOrDarkColor(new Color(0, 77, 145), new Color(88, 157, 246));
    public static final Color COLOR_ACTIVE = new LightOrDarkColor(new Color(225, 9, 21), new Color(186, 51, 36));
    private Action action;
    private boolean override;
    private Color passiveColor = COLOR_PASSIVE;
    private Color activeColor = COLOR_ACTIVE;

    public HyperlinkLabel(Action action) {
        this((String)action.getValue("Name"), action);
    }

    public HyperlinkLabel(String text, Action action) {
        super(text);
        this.action = action;
        this.setupComponent();
        this.setupEventHandlers();
        this.changeState(action.isEnabled());
    }

    public void setPassiveColor(Color passiveColor) {
        this.passiveColor = passiveColor;
        this.setForeground(passiveColor);
    }

    public void setActiveColor(Color activeColor) {
        this.activeColor = activeColor;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.override = true;
        this.changeState(enabled);
    }

    public Action getAction() {
        return this.action;
    }

    private void setupComponent() {
        this.setUnderlined(true);
        this.setForeground(this.passiveColor);
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    private void setupEventHandlers() {
        this.action.addPropertyChangeListener(event -> {
            if (Objects.equals(event.getPropertyName(), "enabled") && !this.override) {
                this.changeState((Boolean)event.getNewValue());
            }
        });
    }

    private void changeState(boolean enabled) {
        this.setUnderlined(enabled);
        if (enabled) {
            this.addMouseListener(this);
        } else {
            this.removeMouseListener(this);
        }
        super.setEnabled(enabled);
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if ((event.getModifiers() & 0x10) == 0) {
            return;
        }
        this.setForeground(this.activeColor);
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if ((event.getModifiers() & 0x10) == 0) {
            return;
        }
        this.setForeground(this.passiveColor);
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if ((event.getModifiers() & 0x10) == 0) {
            return;
        }
        if (this.action != null && this.action.isEnabled()) {
            this.action.actionPerformed(new ActionEvent(this, 0, null));
        }
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }
}

