/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.win32;

import com.install4j.api.Util;
import com.install4j.api.windows.RegistryRoot;
import com.install4j.api.windows.WinRegistry;
import com.install4j.runtime.installer.AbstractRemoteCallable;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.platform.win32.Common;
import java.io.Serializable;
import java.util.StringTokenizer;

public class Win32UserInfo {
    private static final int DOMAIN_ALIAS_RID_ADMINS = 544;
    private static final int DOMAIN_ALIAS_RID_POWER_USERS = 547;
    public static final int ELEVATION_TYPE_NOT_APPLICABLE = 0;
    public static final int ELEVATION_TYPE_DEFAULT = 1;
    public static final int ELEVATION_TYPE_FULL = 2;
    public static final int ELEVATION_TYPE_LIMITED = 3;
    public static final int USER_CREATION_SUCCESS = 0;
    public static final int USER_CREATION_COULD_NOT_INITIALIZE = 1;
    public static final int USER_CREATION_OTHER_ERROR = 2;
    public static final int NERR_GROUP_NOT_FOUND = 2220;
    public static final int NERR_USER_NOT_FOUND = 2221;
    public static final int NERR_GROUP_EXISTS = 2223;
    public static final int NERR_USER_EXISTS = 2224;
    public static final int NERR_PASSWORD_TOO_SHORT = 2245;
    public static final int NERR_NOT_PRIMARY = 2226;
    public static final int NERR_BAD_USER_NAME = 2202;
    public static final int ERROR_ACCESS_DENIED = 5;
    public static final int ERROR_ALIAS_EXISTS = 1379;
    public static final String RIGHT_SERVICE_LOGON = "SeServiceLogonRight";
    public static final int SW_HIDE = 0;
    public static final int SW_SHOWNORMAL = 1;

    private static native boolean isMemberOfGroup0(int var0);

    private static native boolean executeElevated0(String var0, String var1, String var2, int var3);

    private static native int getElevationType0();

    private static native String addUser0(String var0, String var1, String var2, String var3, String var4, boolean var5, boolean var6);

    private static native int deleteUser0(String var0, String var1);

    private static native int deleteLocalGroup0(String var0, String var1);

    private static native String getAccountName0(String var0, boolean var1);

    private static native String getUserProfileDirectory0(String var0, String var1);

    private static native String getUserSid0();

    private static native boolean setLsaAccountRight0(String var0, String var1, boolean var2);

    public static boolean setLsaAccountRight(String sidOrAccountName, String rightName, boolean on) {
        if (!InstallerUtil.isWindows()) {
            return false;
        }
        if (sidOrAccountName == null) {
            throw new IllegalArgumentException("name required");
        }
        if (on && (rightName == null || rightName.trim().isEmpty())) {
            throw new IllegalArgumentException("rightName required");
        }
        return Win32UserInfo.setLsaAccountRight0(sidOrAccountName, rightName, on);
    }

    public static String getAccountName(String sid) {
        return Win32UserInfo.getAccountName(sid, false);
    }

    public static String getAccountName(String sid, boolean unqualified) {
        if (!InstallerUtil.isWindows()) {
            return null;
        }
        String ret = Win32UserInfo.getAccountName0(sid, unqualified);
        if (ret != null && ret.startsWith(" ")) {
            return null;
        }
        return ret;
    }

    public static String getUserProfileDirectory(String sid, String password) {
        if (!InstallerUtil.isAtLeastWindows2000()) {
            return null;
        }
        String ret = Win32UserInfo.getUserProfileDirectory0(sid, password);
        if (ret != null && ret.startsWith(" ")) {
            return null;
        }
        return ret;
    }

    public static boolean isUACDisabled() {
        if (!InstallerUtil.isAtLeastWindowsVista()) {
            return false;
        }
        Object uacEnabled = WinRegistry.getValue(RegistryRoot.HKEY_LOCAL_MACHINE, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Policies\\System", "EnableLUA");
        return uacEnabled instanceof Integer && (Integer)uacEnabled == 0;
    }

    public static boolean deleteUser(String name) {
        if (!InstallerUtil.isWindows()) {
            return false;
        }
        if (name == null) {
            throw new IllegalArgumentException("name required");
        }
        Integer ret = (Integer)ContextImpl.runElevatedInt(new DeleteRemoteCallable(name, false), true);
        return ret != null && (ret == 0 || ret == 2221);
    }

    private static int printInt(int i) {
        System.out.println(i);
        return i;
    }

    public static boolean deleteLocalGroup(String name) {
        if (!InstallerUtil.isWindows()) {
            return false;
        }
        if (name == null) {
            throw new IllegalArgumentException("name required");
        }
        Integer ret = (Integer)ContextImpl.runElevatedInt(new DeleteRemoteCallable(name, true), true);
        return ret != null && (ret == 0 || ret == 2220);
    }

    public static Result addUser(String name, String password, String comment, String localGroupName, String localGroupComment, boolean createGroup, boolean failIfGroupExists) {
        if (!InstallerUtil.isWindows()) {
            return null;
        }
        if (name == null) {
            throw new IllegalArgumentException("name required");
        }
        if (password == null) {
            throw new IllegalArgumentException("password required");
        }
        String result = (String)((Object)ContextImpl.runElevatedInt(new AddUserRemoteCallable(name, password, comment, localGroupName, localGroupComment, createGroup, failIfGroupExists), true));
        if (result == null) {
            return new Result(1, null, null, false);
        }
        if (result.startsWith("S")) {
            StringTokenizer tok = new StringTokenizer(result, " ");
            String userSid = tok.hasMoreTokens() ? tok.nextToken() : null;
            String groupSid = tok.hasMoreTokens() ? tok.nextToken() : null;
            boolean groupCreated = tok.hasMoreTokens() && Boolean.parseBoolean(tok.nextToken());
            return new Result(0, userSid, groupSid, groupCreated);
        }
        int errorCode = 2;
        StringTokenizer tok = new StringTokenizer(result, " ");
        if (tok.countTokens() > 1) {
            tok.nextToken();
            errorCode = Integer.parseInt(tok.nextToken());
        }
        return new Result(errorCode, result);
    }

    public static boolean isAdminUser() {
        return Win32UserInfo.isMemberOfGroup0(544);
    }

    public static boolean isPowerUser() {
        return Win32UserInfo.isMemberOfGroup0(547);
    }

    public static boolean isAtLeastPowerUser() {
        return Win32UserInfo.isPowerUser() || Win32UserInfo.isAdminUser();
    }

    public static String getUserSid() {
        if (!InstallerUtil.isAtLeastWindows2000()) {
            return null;
        }
        return Win32UserInfo.getUserSid0();
    }

    public static boolean executeElevated(String executable, String parameters, String directory) {
        return Win32UserInfo.executeElevated(executable, parameters, directory, 1);
    }

    public static boolean executeElevated(String executable, String parameters, String directory, int showCommand) {
        if (!Util.isAtLeastWindowsVista()) {
            return false;
        }
        return Win32UserInfo.executeElevated0(executable, parameters == null ? "" : parameters, directory, showCommand);
    }

    public static int getElevationType() {
        if (!Util.isAtLeastWindowsVista()) {
            return 0;
        }
        return Win32UserInfo.getElevationType0();
    }

    static {
        Common.init();
    }

    public static class Result {
        private int errorCode;
        private String rawResult;
        private String userSid;
        private String groupSid;
        private boolean groupCreated;

        public Result(int errorCode, String userSid, String groupSid, boolean groupCreated) {
            this.errorCode = errorCode;
            this.userSid = userSid;
            this.groupSid = groupSid;
            this.groupCreated = groupCreated;
        }

        public Result(int errorCode, String rawResult) {
            this.errorCode = errorCode;
            this.rawResult = rawResult;
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        public String getRawResult() {
            return this.rawResult;
        }

        public String getUserSid() {
            return this.userSid;
        }

        public String getGroupSid() {
            return this.groupSid;
        }

        public boolean isGroupCreated() {
            return this.groupCreated;
        }

        public String toString() {
            return "Result{errorCode=" + this.errorCode + ", userSid='" + this.userSid + '\'' + ", groupSid='" + this.groupSid + '\'' + ", groupCreated=" + this.groupCreated + '}';
        }
    }

    private static class AddUserRemoteCallable
    extends AbstractRemoteCallable {
        String name;
        String password;
        String comment;
        String localGroupName;
        String localGroupComment;
        boolean createGroup;
        boolean failIfGroupExists;

        private AddUserRemoteCallable(String name, String password, String comment, String localGroupName, String localGroupComment, boolean createGroup, boolean failIfGroupExists) {
            this.name = name;
            this.password = password;
            this.comment = comment;
            this.localGroupName = localGroupName;
            this.localGroupComment = localGroupComment;
            this.createGroup = createGroup;
            this.failIfGroupExists = failIfGroupExists;
        }

        @Override
        public Serializable execute() {
            return Win32UserInfo.addUser0(this.name, this.password, this.comment, this.localGroupName, this.localGroupComment, this.createGroup, this.failIfGroupExists);
        }
    }

    private static class DeleteRemoteCallable
    extends AbstractRemoteCallable {
        String name;
        boolean group;

        private DeleteRemoteCallable(String name, boolean group) {
            this.name = name;
            this.group = group;
        }

        @Override
        public Serializable execute() {
            String server = null;
            int backslashIndex = this.name.indexOf(92);
            if (backslashIndex > -1) {
                server = this.name.substring(0, backslashIndex);
                this.name = this.name.substring(backslashIndex + 1);
            }
            Win32UserInfo.setLsaAccountRight(this.name, null, false);
            return Integer.valueOf(this.group ? Win32UserInfo.deleteLocalGroup0(server, this.name) : Win32UserInfo.deleteUser0(server, this.name));
        }
    }
}

