/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.components;

import com.install4j.api.UiUtil;
import com.install4j.api.formcomponents.WidgetStyleHandler;
import com.install4j.runtime.filechooser.FileChooser;
import com.install4j.runtime.filechooser.MultiFileFilter;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.components.AbstractFileSelector;
import com.install4j.runtime.installer.frontend.components.FileValidator;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.util.AbstractTextAndButtonPanel;
import com.install4j.runtime.util.FileDrop;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileSystemView;

public class FileSelector
extends AbstractTextAndButtonPanel
implements AbstractFileSelector {
    private static File lastDirectory = null;
    private JTextField txtFile;
    private JButton btnBrowse;
    private String fileFilterName;
    private String[] filteredExtensions;
    private final WidgetStyleHandler widgetStyleHandler;
    private boolean designTime;
    private FileValidator validator;
    private boolean alreadyValidated;
    private String initialBrowserDirectory;

    public FileSelector(String fileFilterName, String[] filteredExtensions, WidgetStyleHandler widgetStyleHandler, boolean designTime) {
        this.fileFilterName = fileFilterName;
        this.filteredExtensions = filteredExtensions;
        this.widgetStyleHandler = widgetStyleHandler;
        this.designTime = designTime;
        this.setupControls();
        this.setupComponent();
        this.setupEventHandlers();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.txtFile.setEnabled(enabled);
        this.btnBrowse.setEnabled(enabled);
    }

    public void initFile(String initialFile) {
        this.txtFile.setText(initialFile);
    }

    @Override
    public void setSelectedFile(File file) {
        this.initFile(file.getPath());
    }

    @Override
    public File getSelectedFile() {
        return new File(InstallerUtil.replaceHomeDir(this.txtFile.getText().trim()));
    }

    public void focusTextField() {
        this.txtFile.requestFocus();
        this.txtFile.setSelectionStart(0);
        this.txtFile.setSelectionEnd(this.txtFile.getDocument().getLength());
    }

    @Override
    public JTextField getTextField() {
        return this.txtFile;
    }

    @Override
    public JButton getButton() {
        return this.btnBrowse;
    }

    @Override
    public void setManualEntryAllowed(boolean manualEntryAllowed) {
        this.txtFile.setEditable(manualEntryAllowed);
    }

    @Override
    public void setValidator(FileValidator validator) {
        this.validator = validator;
    }

    @Override
    public boolean checkSelectedFile() {
        return this.alreadyValidated || this.checkFile(this.getSelectedFile());
    }

    @Override
    public void setInitialBrowserDirectory(String initialBrowserDirectory) {
        this.initialBrowserDirectory = initialBrowserDirectory;
    }

    private boolean checkFile(File file) {
        return this.validator == null || this.validator.isValidFile(file);
    }

    private void setupControls() {
        this.txtFile = new JTextField();
        FileDrop.addTo(this.txtFile, null);
        this.btnBrowse = new JButton(Messages.getString(".ButtonBrowse"));
        if (this.widgetStyleHandler != null) {
            this.widgetStyleHandler.applyWidgetStyle(this.btnBrowse);
            this.widgetStyleHandler.applyWidgetStyle(this.txtFile);
        }
    }

    private void setupComponent() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.weighty = 0.0;
        gc.gridy = 0;
        gc.gridx = 0;
        gc.weightx = 1.0;
        gc.fill = 2;
        this.add((Component)this.txtFile, gc);
        gc.gridx = 1;
        gc.weightx = 0.0;
        gc.fill = 0;
        gc.insets.left = 5;
        this.add((Component)this.btnBrowse, gc);
    }

    private void setupEventHandlers() {
        if (this.designTime) {
            return;
        }
        this.btnBrowse.addActionListener(e -> this.doBrowse());
        this.txtFile.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                FileSelector.this.alreadyValidated = false;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FileSelector.this.alreadyValidated = false;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FileSelector.this.alreadyValidated = false;
            }
        });
    }

    private void doBrowse() {
        File parentDirectory;
        File currentDirectory;
        String selectedPath;
        FileChooser fileChooser = (FileChooser)((FileChooser)FileChooser.create().parent(UiUtil.getParentWindow())).title(Messages.getString(".SelectFile"));
        if (Messages.containsKeyDirectly(".ButtonSelect")) {
            fileChooser.approveButtonText(Messages.getString(".ButtonSelect"));
        }
        if (this.filteredExtensions != null && !this.fileFilterName.trim().isEmpty()) {
            for (int i = 0; i < this.filteredExtensions.length; ++i) {
                String filteredExtension = this.filteredExtensions[i].trim();
                if (filteredExtension.startsWith(".")) {
                    this.filteredExtensions[i] = filteredExtension.substring(1);
                    continue;
                }
                if (!filteredExtension.startsWith("*.")) continue;
                this.filteredExtensions[i] = filteredExtension.substring(2);
            }
            MultiFileFilter fileFilter = new MultiFileFilter(this.filteredExtensions, this.fileFilterName);
            fileChooser.addFileFilter(fileFilter);
            fileChooser.selectedFileFilter(fileFilter);
        }
        if (!(selectedPath = this.txtFile.getText().trim()).isEmpty()) {
            currentDirectory = new File(selectedPath);
        } else if (!this.initialBrowserDirectory.isEmpty()) {
            currentDirectory = new File(this.initialBrowserDirectory);
        } else {
            if (lastDirectory == null) {
                lastDirectory = new File((String)ContextImpl.getSingleContextInt().getVariable("sys.installerDir"));
            }
            currentDirectory = lastDirectory;
        }
        try {
            currentDirectory = currentDirectory.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        while (!(currentDirectory.exists() && currentDirectory.isDirectory() || (parentDirectory = FileSystemView.getFileSystemView().getParentDirectory(currentDirectory)) == null || currentDirectory.equals(parentDirectory))) {
            currentDirectory = parentDirectory;
        }
        if (currentDirectory.exists() && currentDirectory.isDirectory()) {
            fileChooser.currentDirectory(currentDirectory);
        }
        if (fileChooser.select()) {
            File selectedFile = fileChooser.getSelectedFile();
            lastDirectory = selectedFile.getParentFile();
            if (this.checkFile(selectedFile)) {
                this.txtFile.setText(selectedFile.getPath());
                this.alreadyValidated = true;
            } else {
                this.alreadyValidated = false;
            }
        }
    }
}

