/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.install4j.api.actions.InstallAction;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.files.AbstractRecursiveFileAction;
import com.install4j.runtime.beans.actions.files.BackupFileForRollbackAction;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.util.DirectoryUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;

public class DeleteFileAction
extends AbstractRecursiveFileAction {
    private boolean backupForRollback = true;
    private List<BackupFileForRollbackAction> dirRollbackActions = new ArrayList<BackupFileForRollbackAction>();

    public boolean isBackupForRollback() {
        return this.replaceWithTextOverride("backupForRollback", this.backupForRollback);
    }

    public void setBackupForRollback(boolean backupForRollback) {
        this.backupForRollback = backupForRollback;
    }

    @Override
    protected boolean executeForSingleRecursiveFile(Context context, File file, File relativeSourceFile, ProgressAdapter progressAdapter) throws UserCanceledException, IOException {
        if (!DirectoryUtil.isRegularDirectory(file)) {
            boolean success;
            this.deleteWithRetry(file, context);
            boolean bl = success = !file.exists();
            if (!success) {
                Logger.getInstance().log(this, "The file " + file.getPath() + " cannot be deleted", false);
            }
            return success;
        }
        return true;
    }

    @Override
    protected boolean postProcessDirectory(Context context, File file) throws UserCanceledException {
        boolean success;
        this.deleteDir(context, file);
        boolean bl = success = !this.isRecursive() || !file.exists() || this.getFileFilter() != null || this.getDirectoryFilter() != null;
        if (!success) {
            Logger.getInstance().log(this, "Could not delete directory " + file, false);
        }
        return success;
    }

    private void deleteDir(Context context, File usedFile) throws UserCanceledException {
        BackupFileForRollbackAction rollbackAction = this.deleteFile(usedFile, context);
        if (rollbackAction != null) {
            this.dirRollbackActions.add(rollbackAction);
        }
    }

    private void deleteWithRetry(File usedFile, Context context) throws UserCanceledException {
        for (int i = 0; i < 3; ++i) {
            if (i > 0) {
                try {
                    Thread.sleep(350L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            BackupFileForRollbackAction rollbackAction = this.deleteFile(usedFile, context);
            if (!usedFile.exists()) {
                if (rollbackAction != null) {
                    this.addRollbackAction(rollbackAction);
                }
                return;
            }
            if (rollbackAction != null && rollbackAction.getBackupFile() != null) {
                rollbackAction.getBackupFile().delete();
            }
            if (DeleteFileAction.isPossiblyWritable(usedFile)) continue;
            return;
        }
    }

    private static boolean isPossiblyWritable(File file) {
        try {
            return Files.isWritable(file.toPath());
        }
        catch (Throwable t) {
            return true;
        }
    }

    private BackupFileForRollbackAction deleteFile(File usedFile, Context context) throws UserCanceledException {
        if (context instanceof InstallerContext && this.shouldRollback()) {
            BackupFileForRollbackAction backupFileForRollbackAction = new BackupFileForRollbackAction(usedFile, true, false, false);
            backupFileForRollbackAction.install((InstallerContext)context);
            return backupFileForRollbackAction;
        }
        usedFile.delete();
        return null;
    }

    private boolean shouldRollback() {
        return this.isBackupForRollback() && !this.isSuppressRollback();
    }

    @Override
    public void rollback(InstallerContext context) {
        for (int i = this.dirRollbackActions.size() - 1; i >= 0; --i) {
            InstallAction action = this.dirRollbackActions.get(i);
            action.rollback(context);
        }
        super.rollback(context);
    }

    @Override
    public boolean isRollbackSupported() {
        return this.isBackupForRollback();
    }

    @Override
    protected boolean isErrorIfFileMissing() {
        return false;
    }
}

