/*
 * Decompiled with CFR 0.152.
 */
package com.ejt.internal.io;

import com.ejt.internal.util.CheckedSupplier;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.concurrent.ThreadSafe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ThreadSafe
public class DirectoryLocker {
    public static final String LOCK_FILE_NAME = ".lock";
    private static final Map<Path, ReentrantLock> directoryLocks = Collections.synchronizedMap(new WeakHashMap());

    public static <T> T withLock(@NotNull File directory, @NotNull String lockMessage, @Nullable Consumer<String> logHandler, @NotNull Supplier<T> handler) {
        try {
            return (T)DirectoryLocker.withLockChecked(directory, lockMessage, logHandler, handler::get);
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static <T> T withLockChecked(@NotNull File directory, @NotNull String lockMessage, @Nullable Consumer<String> logHandler, @NotNull CheckedSupplier<T> handler) throws Throwable {
        return DirectoryLocker.withLockCheckedNormalized(directory.toPath().normalize(), lockMessage, logHandler, handler);
    }

    /*
     * Exception decompiling
     */
    private static <T> T withLockCheckedNormalized(@NotNull Path directory, @NotNull String lockMessage, @Nullable Consumer<String> logHandler, @NotNull CheckedSupplier<T> handler) throws Throwable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static FileLock acquireLock(@NotNull FileChannel fileChannel, String lockMessage, @Nullable Consumer<String> logHandler) throws IOException {
        FileLock directLock = fileChannel.tryLock();
        if (directLock != null) {
            return directLock;
        }
        DirectoryLocker.log(lockMessage, logHandler);
        FileLock lock = fileChannel.lock();
        DirectoryLocker.log("Lock acquired", logHandler);
        return lock;
    }

    private static void log(@NotNull String message, @Nullable Consumer<String> logHandler) {
        if (logHandler != null) {
            logHandler.accept(message);
        } else {
            System.err.println(message);
        }
    }

    private static /* synthetic */ ReentrantLock lambda$withLockCheckedNormalized$0(Path p) {
        return new ReentrantLock();
    }
}

