package com.install4j.api.context;

/**
 * The context provided by the uninstaller.
 * In addition to the methods in the {@code Context} interface, this extended context offers methods that are specific
 * to the uninstaller.
 * @author ej-technologies GmbH
 */
public interface UninstallerContext extends Context {

    /**
     * Returns whether the uninstaller is running as part of an upgrade.
     * This method returns {@code true} when the uninstaller is run by the "Uninstall previous installation" of another
     * installer performing an upgrade into the same directory.
     * @return {@code true} or {@code false}.
     */
    boolean isUninstallForUpgrade();
}
