package com.install4j.api.beaninfo;

import com.install4j.api.beans.Bean;

import java.awt.*;

/**
 * Customizer component for a property that is used in a dialog. Implementing classes must extend {@link Component}.
 * A Property customizer is specified in a {@link PropertyConverter property converter}.
 * Property converters are registered on a per-bean basis with
 * {@link Install4JBeanInfo#setPropertyConverters(PropertyConverter[])}.
 * @see PropertyConverter#getPropertyCustomizerClass()
 */
public interface PropertyCustomizer {

    /**
     * Sets the property value and the bean. The install4j IDE will call this method just before
     * the property customizer dialog is shown.
     * @param value the property value
     * @param bean the bean
     */
    void setValue(Object value, Bean bean);

    /**
     * Called if the property customizer dialog is exited with the OK button.
     * If the user input is not valid, you can return {@code false} in order to
     * prevent the dialog from closing. You should display a warning message in that case.
     * @return if the dialog should be closed
     */
    boolean ok();

    /**
     * Called if the property customizer dialog is exited with the Cancel button.
     * If you have already modified the bean, you should revert it to its original state.
     */
    void cancel();

    /**
     * Called by the install4j IDE when the dialog is closed to determine if the
     * user has made any modifications.
     * @return {@code true} if modified
     */
    boolean isModified();

    /**
     * Called by the install4j IDE after the property customizer is initialized and sets the parent window.
     * @param window the parent window
     */
    void setParentWindow(Window window);

}
