package com.install4j.api.beaninfo;

/**
 * Interface for mapping values and descriptions of enumerated properties.
 * Instances of this class can be registered with {@link Install4JBeanInfo#setEnumerationMappers(EnumerationMapper[])}.
 * In the install4j GUI, an enumerated property will be displayed with the enumeration entry name that corresponds to the
 * object value of the property, and the user can choose a value from a drop-down list.
 * <p>This class is not needed for displaying java enums, which are automatically presented with a drop-down list,
 * displaying the result of the invocation of their {@code toString()} methods.
 * <p>In concept, this class is similar to the {@link PropertyConverter} class.
 */
public interface EnumerationMapper {

    /**
     * A default context that you can use in the {@link #getContext()}  method if there is only one
     * enumeration mapper for the property type returned by{@link #getEnumerationClass()}}
     */
    String DEFAULT_CONTEXT = "defaultEnumContext";

    /**
     * Return the property type for which this enumeration mapper is eligible.
     * The objects in the @{EnumerationMapEntry} returned by {@link #getEnumerationMapEntries}
     * must be of this type.
     * @return the class of the enumerated property
     */
    Class getEnumerationClass();

    /**
     * Defines the enumeration.
     * @return the enumeration map entries
     */
    EnumerationMapEntry[] getEnumerationMapEntries();

    /**
     * The property descriptor of an enumerated property must have a non-null context that corresponds to the
     * return value of this method. In this way, the runtime knows that this enumeration mapper should be used
     * for displaying and editing properties. The context must not be globally unique,
     * enumeration mappers of other property types can use the same context value.
     * <p>For classes that do not have default handlers in install4j,
     * the enumeration mapper will also be used if this method returns {@link #DEFAULT_CONTEXT},
     * the {@link #getEnumerationClass} method returns the class of the property and the context of the property
     * is not set. However, it is safer not to rely on that behavior.
     *
     * @return the context that will be used by the enumerated properties
     */
    String getContext();
}
